/*
 * Decompiled with CFR 0.152.
 */
package org.ext.uberfire.social.activities.server;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import org.ext.uberfire.social.activities.model.SocialActivitiesEvent;
import org.ext.uberfire.social.activities.persistence.SocialUserClusterMessaging;
import org.ext.uberfire.social.activities.persistence.SocialUserClusterPersistence;
import org.ext.uberfire.social.activities.persistence.SocialUserInstancePersistence;
import org.ext.uberfire.social.activities.server.SocialUserServicesExtendedBackEndImpl;
import org.ext.uberfire.social.activities.service.SocialEventTypeRepositoryAPI;
import org.ext.uberfire.social.activities.service.SocialUserPersistenceAPI;
import org.uberfire.backend.server.UserServicesImpl;
import org.uberfire.backend.server.io.ConfigIOServiceProducer;
import org.uberfire.commons.cluster.ClusterJMSService;
import org.uberfire.commons.cluster.ClusterService;
import org.uberfire.commons.services.cdi.Startup;
import org.uberfire.commons.services.cdi.StartupType;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;

@ApplicationScoped
@Startup(value=StartupType.BOOTSTRAP)
public class SocialUserPersistenceProducer {
    private Gson gson;
    private Type gsonCollectionType;
    @Inject
    @Named(value="configIO")
    private IOService ioService;
    @Inject
    @Named(value="systemFS")
    private FileSystem fileSystem;
    @Inject
    private SocialEventTypeRepositoryAPI socialEventTypeRepository;
    @Inject
    private UserServicesImpl userServices;
    private SocialUserPersistenceAPI socialUserPersistenceAPI;
    @Inject
    private SocialUserClusterMessaging socialUserClusterMessaging;
    private ClusterService clusterService;

    @PostConstruct
    public void setup() {
        this.gsonFactory();
        this.clusterService = new ClusterJMSService();
        IOService _ioService = this.getConfigIOServiceProducer().configIOService();
        SocialUserServicesExtendedBackEndImpl userServicesBackend = new SocialUserServicesExtendedBackEndImpl(this.fileSystem);
        this.setupSocialUserPersistenceAPI(_ioService, userServicesBackend);
    }

    void setupSocialUserPersistenceAPI(IOService _ioService, SocialUserServicesExtendedBackEndImpl userServicesBackend) {
        if (!this.clusterService.isAppFormerClustered()) {
            this.socialUserPersistenceAPI = new SocialUserInstancePersistence(userServicesBackend, this.userServices, _ioService, this.gson);
        } else {
            this.socialUserPersistenceAPI = new SocialUserClusterPersistence(userServicesBackend, this.userServices, _ioService, this.gson, this.socialUserClusterMessaging);
            this.socialUserClusterMessaging.setup(this.clusterService, this.socialUserPersistenceAPI);
        }
        this.socialUserPersistenceAPI.setup();
    }

    ConfigIOServiceProducer getConfigIOServiceProducer() {
        return ConfigIOServiceProducer.getInstance();
    }

    @Produces
    @Named(value="socialUserPersistenceAPI")
    public SocialUserPersistenceAPI socialUserPersistenceAPI() {
        return this.socialUserPersistenceAPI;
    }

    void gsonFactory() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        this.gson = gsonBuilder.create();
        this.gsonCollectionType = new TypeToken<Collection<SocialActivitiesEvent>>(){}.getType();
    }
}

