/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.elastic.provider;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.transport.client.PreBuiltTransportClient;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.ext.metadata.backend.elastic.exceptions.MetadataException;

public class ElasticSearchContext {
    private static final String PORT = "org.appformer.ext.metadata.elastic.port";
    private static final String HOST = "org.appformer.ext.metadata.elastic.host";
    private static final String CLUSTER = "org.appformer.ext.metadata.elastic.cluster";
    private static final String RETRIES = "org.appformer.ext.metadata.elastic.retries";
    public static final String ES_CLUSTER_NAME = "cluster.name";
    public static final String ES_TRANSPORT_TYPE = "transport.type";
    public static final String ES_NETTY_4 = "netty4";
    private static ElasticSearchContext INSTANCE;
    private final String cluster;
    private final int retries;
    private TransportClient transportClient;
    private String hostname;
    private int port;
    private Logger logger = LoggerFactory.getLogger(ElasticSearchContext.class);

    public static ElasticSearchContext getInstance() {
        if (INSTANCE == null) {
            HashMap<String, String> properties = new HashMap<String, String>(){
                {
                    this.put(ElasticSearchContext.HOST, System.getProperty(ElasticSearchContext.HOST, "127.0.0.1"));
                    this.put(ElasticSearchContext.PORT, System.getProperty(ElasticSearchContext.PORT, "9300"));
                    this.put(ElasticSearchContext.CLUSTER, System.getProperty(ElasticSearchContext.CLUSTER, "kie-cluster"));
                    this.put(ElasticSearchContext.RETRIES, System.getProperty(ElasticSearchContext.RETRIES, "10"));
                }
            };
            INSTANCE = new ElasticSearchContext((Map<String, String>)properties);
        }
        return INSTANCE;
    }

    public static ElasticSearchContext getInstance(Map<String, String> properties) {
        if (INSTANCE == null) {
            INSTANCE = new ElasticSearchContext(properties);
        }
        return INSTANCE;
    }

    private ElasticSearchContext(Map<String, String> properties) {
        this.port = Integer.parseInt(PortablePreconditions.checkNotEmpty((String)"port", (String)properties.get(PORT)));
        this.hostname = PortablePreconditions.checkNotEmpty((String)"host", (String)properties.get(HOST));
        this.cluster = (String)PortablePreconditions.checkNotNull((String)"cluster", (Object)properties.get(CLUSTER));
        this.retries = Integer.parseInt(properties.get(RETRIES));
    }

    private TransportClient createTransportClient(String cluster, String hostname, int port) {
        int retries = 0;
        TransportClient client = null;
        while (client == null && retries <= this.retries) {
            try {
                this.logger.info("Creating Elasticsearch transport client");
                Settings settings = Settings.builder().put(ES_CLUSTER_NAME, cluster).put(ES_TRANSPORT_TYPE, ES_NETTY_4).build();
                client = new PreBuiltTransportClient(settings, new Class[0]).addTransportAddress((TransportAddress)new InetSocketTransportAddress(InetAddress.getByName(hostname), port));
            }
            catch (Exception e) {
                this.logger.error("Error trying to create Transport Client, retrying", (Throwable)e);
                ++retries;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e1) {
                    this.logger.error("Error trying to create Transport Client, retrying", (Throwable)e1);
                }
            }
        }
        if (client == null) {
            throw new MetadataException("Error trying to create Transport Client");
        }
        return client;
    }

    public Client getTransportClient() {
        if (this.transportClient == null) {
            this.transportClient = this.createTransportClient(this.cluster, this.hostname, this.port);
        }
        return this.transportClient;
    }

    public void destroy() {
        this.transportClient.close();
        this.transportClient = null;
    }
}

