/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.widgets.menu;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.client.menu.AuthFilterMenuVisitor;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.ActivityManager;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.events.PerspectiveChange;
import org.uberfire.client.workbench.events.PlaceMaximizedEvent;
import org.uberfire.client.workbench.events.PlaceMinimizedEvent;
import org.uberfire.client.workbench.widgets.menu.WorkbenchMenuBar;
import org.uberfire.client.workbench.widgets.menu.base.WorkbenchBaseMenuPresenter;
import org.uberfire.client.workbench.widgets.menu.base.WorkbenchBaseMenuView;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.ActivityResourceType;
import org.uberfire.workbench.model.menu.EnabledStateChangeListener;
import org.uberfire.workbench.model.menu.MenuCustom;
import org.uberfire.workbench.model.menu.MenuGroup;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuItemCommand;
import org.uberfire.workbench.model.menu.MenuItemPerspective;
import org.uberfire.workbench.model.menu.MenuItemPlain;
import org.uberfire.workbench.model.menu.MenuPosition;
import org.uberfire.workbench.model.menu.MenuVisitor;
import org.uberfire.workbench.model.menu.Menus;
import org.uberfire.workbench.model.menu.impl.BaseMenuVisitor;

public class WorkbenchMenuBarPresenter
extends WorkbenchBaseMenuPresenter
implements WorkbenchMenuBar {
    protected AuthorizationManager authzManager;
    protected User identity;
    private boolean useExpandedMode = true;
    private boolean expanded = true;
    private PerspectiveManager perspectiveManager;
    private PlaceManager placeManager;
    private ActivityManager activityManager;
    private View view;

    WorkbenchMenuBarPresenter(AuthorizationManager authzManager, PerspectiveManager perspectiveManager, PlaceManager placeManager, ActivityManager activityManager, User identity, View view) {
        this.authzManager = authzManager;
        this.perspectiveManager = perspectiveManager;
        this.placeManager = placeManager;
        this.activityManager = activityManager;
        this.identity = identity;
        this.view = view;
        this.setup();
    }

    protected void setup() {
        this.view.addExpandHandler(new Command(){

            public void execute() {
                WorkbenchMenuBarPresenter.this.expanded = true;
            }
        });
        this.view.addCollapseHandler(new Command(){

            public void execute() {
                WorkbenchMenuBarPresenter.this.expanded = false;
            }
        });
    }

    public IsWidget getView() {
        return this.view;
    }

    @Override
    protected WorkbenchBaseMenuView getBaseView() {
        return this.view;
    }

    @Override
    protected void visitMenus(Menus addedMenu) {
        addedMenu.accept((MenuVisitor)new AuthFilterMenuVisitor(this.authzManager, this.identity, (MenuVisitor)new BaseMenuVisitor(){
            private String parentId = null;

            public boolean visitEnter(MenuGroup menuGroup) {
                this.parentId = WorkbenchMenuBarPresenter.this.getMenuItemId((MenuItem)menuGroup);
                WorkbenchMenuBarPresenter.this.view.addGroupMenuItem(this.parentId, menuGroup.getCaption(), menuGroup.getPosition());
                return true;
            }

            public void visitLeave(MenuGroup menuGroup) {
                this.parentId = null;
            }

            public void visit(MenuItemPlain menuItemPlain) {
                WorkbenchMenuBarPresenter.this.view.addMenuItem(WorkbenchMenuBarPresenter.this.getMenuItemId((MenuItem)menuItemPlain), menuItemPlain.getCaption(), this.parentId, null, menuItemPlain.getPosition());
                this.setupEnableDisableMenuItem((MenuItem)menuItemPlain);
            }

            public void visit(MenuCustom<?> menuCustom) {
                Object build = menuCustom.build();
                if (build instanceof IsWidget) {
                    WorkbenchMenuBarPresenter.this.view.addCustomMenuItem(((IsWidget)build).asWidget(), menuCustom.getPosition());
                } else {
                    WorkbenchMenuBarPresenter.this.view.addMenuItem(WorkbenchMenuBarPresenter.this.getMenuItemId(menuCustom), menuCustom.getCaption(), this.parentId, null, menuCustom.getPosition());
                }
                this.setupEnableDisableMenuItem((MenuItem)menuCustom);
            }

            public void visit(MenuItemCommand menuItemCommand) {
                WorkbenchMenuBarPresenter.this.view.addMenuItem(WorkbenchMenuBarPresenter.this.getMenuItemId((MenuItem)menuItemCommand), menuItemCommand.getCaption(), this.parentId, menuItemCommand.getCommand(), menuItemCommand.getPosition());
                this.setupEnableDisableMenuItem((MenuItem)menuItemCommand);
            }

            public void visit(final MenuItemPerspective menuItemPerspective) {
                String id = menuItemPerspective.getPlaceRequest().getIdentifier();
                WorkbenchMenuBarPresenter.this.view.addMenuItem(id, menuItemPerspective.getCaption(), this.parentId, new Command(){

                    public void execute() {
                        WorkbenchMenuBarPresenter.this.placeManager.goTo(menuItemPerspective.getPlaceRequest());
                    }
                }, menuItemPerspective.getPosition());
                this.setupEnableDisableMenuItem((MenuItem)menuItemPerspective);
                PlaceRequest placeRequest = menuItemPerspective.getPlaceRequest();
                if (WorkbenchMenuBarPresenter.this.perspectiveManager.getCurrentPerspective() != null && placeRequest.equals(WorkbenchMenuBarPresenter.this.perspectiveManager.getCurrentPerspective().getPlace())) {
                    WorkbenchMenuBarPresenter.this.view.selectMenuItem(id);
                }
            }

            private void setupEnableDisableMenuItem(final MenuItem menuItem) {
                menuItem.addEnabledStateChangeListener(new EnabledStateChangeListener(){

                    public void enabledStateChanged(boolean enabled) {
                        WorkbenchMenuBarPresenter.this.view.enableMenuItem(WorkbenchMenuBarPresenter.this.getMenuItemId(menuItem), enabled);
                    }
                });
            }
        }));
        this.synchronizeUIWithMenus(addedMenu.getItems());
    }

    private String getMenuItemId(MenuItem menuItem) {
        return menuItem.getIdentifier() == null ? menuItem.getCaption() : menuItem.getIdentifier();
    }

    protected void addPerspectiveMenus(PerspectiveActivity perspective) {
        final String perspectiveId = perspective.getIdentifier();
        Menus menus = perspective.getMenus();
        this.view.clearContextMenu();
        if (menus != null) {
            menus.accept((MenuVisitor)new AuthFilterMenuVisitor(this.authzManager, this.identity, (MenuVisitor)new BaseMenuVisitor(){
                private String parentId = null;

                public boolean visitEnter(MenuGroup menuGroup) {
                    this.parentId = WorkbenchMenuBarPresenter.this.getMenuItemId((MenuItem)menuGroup);
                    WorkbenchMenuBarPresenter.this.view.addContextGroupMenuItem(perspectiveId, this.parentId, menuGroup.getCaption(), menuGroup.getPosition());
                    return true;
                }

                public void visitLeave(MenuGroup menuGroup) {
                    this.parentId = null;
                }

                public void visit(MenuItemPlain menuItemPlain) {
                    WorkbenchMenuBarPresenter.this.view.addContextMenuItem(perspectiveId, WorkbenchMenuBarPresenter.this.getMenuItemId((MenuItem)menuItemPlain), menuItemPlain.getCaption(), this.parentId, null, menuItemPlain.getPosition());
                    this.setupEnableDisableContextMenuItem((MenuItem)menuItemPlain);
                }

                public void visit(MenuCustom<?> menuCustom) {
                    WorkbenchMenuBarPresenter.this.view.addContextMenuItem(perspectiveId, WorkbenchMenuBarPresenter.this.getMenuItemId(menuCustom), menuCustom.getCaption(), this.parentId, null, menuCustom.getPosition());
                    this.setupEnableDisableContextMenuItem((MenuItem)menuCustom);
                }

                public void visit(MenuItemCommand menuItemCommand) {
                    WorkbenchMenuBarPresenter.this.view.addContextMenuItem(perspectiveId, WorkbenchMenuBarPresenter.this.getMenuItemId((MenuItem)menuItemCommand), menuItemCommand.getCaption(), this.parentId, menuItemCommand.getCommand(), menuItemCommand.getPosition());
                    this.setupEnableDisableContextMenuItem((MenuItem)menuItemCommand);
                }

                public void visit(final MenuItemPerspective menuItemPerspective) {
                    WorkbenchMenuBarPresenter.this.view.addContextMenuItem(perspectiveId, menuItemPerspective.getPlaceRequest().getIdentifier(), menuItemPerspective.getCaption(), this.parentId, new Command(){

                        public void execute() {
                            WorkbenchMenuBarPresenter.this.placeManager.goTo(menuItemPerspective.getPlaceRequest());
                        }
                    }, menuItemPerspective.getPosition());
                    this.setupEnableDisableContextMenuItem((MenuItem)menuItemPerspective);
                }

                private void setupEnableDisableContextMenuItem(final MenuItem menuItem) {
                    menuItem.addEnabledStateChangeListener(new EnabledStateChangeListener(){

                        public void enabledStateChanged(boolean enabled) {
                            WorkbenchMenuBarPresenter.this.view.enableContextMenuItem(WorkbenchMenuBarPresenter.this.getMenuItemId(menuItem), enabled);
                        }
                    });
                }
            }));
            this.synchronizeUIWithMenus(menus.getItems());
        }
    }

    protected void onPerspectiveChange(PerspectiveChange perspectiveChange) {
        Activity activity = this.activityManager.getActivity(perspectiveChange.getPlaceRequest());
        if (activity != null && activity.isType(ActivityResourceType.PERSPECTIVE.name())) {
            this.addPerspectiveMenus((PerspectiveActivity)activity);
        }
        this.view.selectMenuItem(perspectiveChange.getPlaceRequest().getIdentifier());
    }

    protected void onPlaceMinimized(PlaceMinimizedEvent event) {
        if (this.isUseExpandedMode()) {
            this.view.expand();
        }
    }

    protected void onPlaceMaximized(PlaceMaximizedEvent event) {
        this.view.collapse();
    }

    @Override
    public void clear() {
        this.view.clear();
    }

    @Override
    public void expand() {
        this.useExpandedMode = true;
        this.view.expand();
    }

    @Override
    public boolean isUseExpandedMode() {
        return this.useExpandedMode;
    }

    @Override
    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public void collapse() {
        this.useExpandedMode = false;
        this.view.collapse();
    }

    @Override
    public void addCollapseHandler(Command command) {
        this.view.addCollapseHandler(command);
    }

    @Override
    public void addExpandHandler(Command command) {
        this.view.addExpandHandler(command);
    }

    public static interface View
    extends WorkbenchBaseMenuView,
    IsWidget {
        @Override
        public void clear();

        public void addMenuItem(String var1, String var2, String var3, Command var4, MenuPosition var5);

        public void addCustomMenuItem(Widget var1, MenuPosition var2);

        public void addGroupMenuItem(String var1, String var2, MenuPosition var3);

        public void selectMenuItem(String var1);

        public void addContextMenuItem(String var1, String var2, String var3, String var4, Command var5, MenuPosition var6);

        public void addContextGroupMenuItem(String var1, String var2, String var3, MenuPosition var4);

        public void clearContextMenu();

        public void expand();

        public void collapse();

        public void addCollapseHandler(Command var1);

        public void addExpandHandler(Command var1);

        public void enableMenuItem(String var1, boolean var2);

        public void enableContextMenuItem(String var1, boolean var2);
    }
}

