/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.file.popups;

import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.editor.commons.client.file.RestoreUtil;
import org.uberfire.ext.editor.commons.client.resources.i18n.CommonConstants;
import org.uberfire.ext.editor.commons.version.VersionService;
import org.uberfire.ext.editor.commons.version.events.RestoreEvent;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.mvp.ParameterizedCommand;

@Dependent
public class RestorePopUpPresenter {
    protected ParameterizedCommand<String> command;
    private BusyIndicatorView busyIndicatorView;
    private Caller<VersionService> versionService;
    private Event<RestoreEvent> restoreEvent;
    private RestoreUtil restoreUtil;
    private View view;

    @Inject
    public RestorePopUpPresenter(View view, BusyIndicatorView busyIndicatorView, Caller<VersionService> versionService, Event<RestoreEvent> restoreEvent, RestoreUtil restoreUtil) {
        this.view = view;
        this.busyIndicatorView = busyIndicatorView;
        this.versionService = versionService;
        this.restoreEvent = restoreEvent;
        this.restoreUtil = restoreUtil;
    }

    @PostConstruct
    public void setup() {
        this.view.init(this);
    }

    public void restore() {
        this.command.execute((Object)this.view.getComment());
        this.view.hide();
    }

    public void show(ObservablePath currentPath, String currentVersionRecordUri) {
        this.command = this.restoreCommand(currentPath, currentVersionRecordUri);
        this.view.show();
    }

    public void cancel() {
        this.view.hide();
    }

    private HasBusyIndicatorDefaultErrorCallback errorCallback() {
        return new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.busyIndicatorView);
    }

    private RemoteCallback<Path> successCallback(String currentVersionRecordUri) {
        return restored -> {
            this.busyIndicatorView.hideBusyIndicator();
            this.restoreEvent.fire((Object)new RestoreEvent(this.restoreUtil.createObservablePath((Path)restored, currentVersionRecordUri)));
        };
    }

    public ParameterizedCommand<String> restoreCommand(ObservablePath currentPath, String currentVersionRecordUri) {
        return comment -> {
            this.busyIndicatorView.showBusyIndicator(CommonConstants.INSTANCE.Restoring());
            ((VersionService)this.versionService.call(this.successCallback(currentVersionRecordUri), (ErrorCallback)this.errorCallback())).restore((Path)currentPath, comment);
        };
    }

    public static interface View
    extends UberElement<RestorePopUpPresenter> {
        public void show();

        public void hide();

        public String getComment();
    }
}

