/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.cache;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.weld.util.Function;
import org.jboss.weld.util.LazyValueHolder;
import org.jboss.weld.util.ValueHolder;
import org.jboss.weld.util.cache.ComputingCache;

class ReentrantMapBackedComputingCache<K, V>
implements ComputingCache<K, V>,
Iterable<V> {
    private final ConcurrentMap<K, ValueHolder<V>> map = new ConcurrentHashMap<K, ValueHolder<V>>();
    private final Long maxSize;
    private final Function<K, ValueHolder<V>> function;

    ReentrantMapBackedComputingCache(Function<K, V> computingFunction, Long maxSize) {
        this(computingFunction, LazyValueHolder.forValue(), maxSize);
    }

    ReentrantMapBackedComputingCache(final Function<K, V> computingFunction, final Function<V, ValueHolder<V>> valueHolderFunction, Long maxSize) {
        this.maxSize = maxSize;
        this.function = new Function<K, ValueHolder<V>>(){

            @Override
            public ValueHolder<V> apply(K key) {
                return (ValueHolder)valueHolderFunction.apply(computingFunction.apply(key));
            }
        };
    }

    @Override
    public V getValue(K key) {
        ValueHolder<V> value = (ValueHolder<V>)this.map.get(key);
        if (value == null) {
            value = this.function.apply(key);
            ValueHolder<V> previous = this.map.putIfAbsent(key, value);
            if (previous != null) {
                value = previous;
            }
            if (this.maxSize != null && this.size() > this.maxSize) {
                this.clear();
            }
        }
        return (V)value.get();
    }

    @Override
    public <T> T getCastValue(Object key) {
        return (T)this.getValue(key);
    }

    @Override
    public V getValueIfPresent(K key) {
        ValueHolder value = (ValueHolder)this.map.get(key);
        if (value == null) {
            return null;
        }
        return (V)value.getIfPresent();
    }

    @Override
    public long size() {
        return this.map.size();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public void invalidate(Object key) {
        this.map.remove(key);
    }

    @Override
    public Iterable<V> getAllPresentValues() {
        return this;
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public Iterator<V> iterator() {
        return new Iterator<V>(){
            private final Iterator<ValueHolder<V>> delegate;
            private V next;
            {
                this.delegate = ReentrantMapBackedComputingCache.this.map.values().iterator();
                this.next = this.findNext();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            private V findNext() {
                while (this.delegate.hasNext()) {
                    Object next = this.delegate.next().getIfPresent();
                    if (next == null) continue;
                    return next;
                }
                return null;
            }

            @Override
            public V next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object current = this.next;
                this.next = this.findNext();
                return current;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }
}

