/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.dom;

import elemental2.core.Function;
import java.lang.Double;
import java.lang.Object;
import java.lang.String;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class Document extends Node {
  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface CreateTextNodeDataUnionType {
    @JsOverlay
    static CreateTextNodeDataUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.castToDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType
  public interface RegisterElementOptionsType {
    @JsProperty
    String getExtends();

    @JsProperty
    void setExtends(String extends_);
  }

  @JsType
  public interface RegisterOptionsType {
    @JsProperty
    String getExtends();

    @JsProperty
    void setExtends(String extends_);
  }

  public double childElementCount;
  public HTMLScriptElement currentScript;
  public DocumentType doctype;
  public Element documentElement;
  public String documentURI;
  public DOMConfiguration domConfig;
  public Element firstElementChild;
  public FontFaceSet fonts;
  public Element fullscreenElement;
  public boolean fullscreenEnabled;
  public HTMLHeadElement head;
  public boolean hidden;
  public DOMImplementation implementation;
  public String inputEncoding;
  public Element lastElementChild;
  public boolean mozFullScreen;
  public Element mozFullScreenElement;
  public boolean mozFullScreenEnabled;
  public boolean mozHidden;
  public String mozVisibilityState;
  public Element msFullscreenElement;
  public boolean msFullscreenEnabled;
  public boolean msHidden;
  public String msVisibilityState;
  public Element scrollingElement;
  public boolean strictErrorChecking;
  public String visibilityState;
  public Element webkitCurrentFullScreenElement;
  public boolean webkitFullScreenKeyboardInputAllowed;
  public Element webkitFullscreenElement;
  public boolean webkitFullscreenEnabled;
  public boolean webkitHidden;
  public boolean webkitIsFullScreen;
  public String webkitVisibilityState;
  public String xmlEncoding;
  public boolean xmlStandalone;
  public String xmlVersion;

  public native Node adoptNode(Node externalNode);

  public native CaretPosition caretPositionFromPoint(double x, double y);

  public native Attr createAttribute(String name);

  public native Attr createAttributeNS(String namespaceURI, String qualifiedName);

  public native CDATASection createCDATASection(String data);

  public native Comment createComment(String data);

  public native DocumentFragment createDocumentFragment();

  public native Element createElement(String tagName, String typeExtension);

  public native Element createElement(String tagName);

  public native Element createElementNS(
      String namespaceURI, String qualifiedName, String typeExtension);

  public native Element createElementNS(String namespaceURI, String qualifiedName);

  public native EntityReference createEntityReference(String name);

  public native ProcessingInstruction createProcessingInstruction(String target, String data);

  public native Text createTextNode(CreateTextNodeDataUnionType data);

  @JsOverlay
  public final Text createTextNode(String data) {
    return createTextNode(Js.<CreateTextNodeDataUnionType>uncheckedCast(data));
  }

  @JsOverlay
  public final Text createTextNode(double data) {
    return createTextNode(Js.<CreateTextNodeDataUnionType>uncheckedCast(data));
  }

  public native Touch createTouch(
      Window view,
      EventTarget target,
      double identifier,
      double pageX,
      double pageY,
      double screenX,
      double screenY);

  public native TouchList createTouchList(Touch[] touches);

  public native Element elementFromPoint(double x, double y);

  public native void exitFullscreen();

  public native Element getElementById(String s);

  public native NodeList<Element> getElementsByTagName(String tagname);

  public native NodeList<Element> getElementsByTagNameNS(String namespace, String name);

  public native Node importNode(Node externalNode, boolean deep);

  public native Object mozCancelFullScreen();

  public native void normalizeDocument();

  public native Object postMessage(String message);

  public native Element querySelector(String selectors);

  public native NodeList<Element> querySelectorAll(String selectors);

  public native Object register(String type, RegisterOptionsType options);

  public native Function registerElement(String type, RegisterElementOptionsType options);

  public native Function registerElement(String type);

  public native Node renameNode(Node n, String namespaceURI, String qualifiedName);

  public native Object webkitCancelFullScreen();
}
