/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.service.shared.meta.processing.impl;

import java.util.HashMap;
import java.util.Map;
import org.kie.workbench.common.forms.model.MetaDataEntry;
import org.kie.workbench.common.forms.service.shared.meta.processing.MetaDataEntryManager;
import org.kie.workbench.common.forms.service.shared.meta.processing.MetaDataEntryProcessor;

public abstract class AbstractMetaDataEntryManager
implements MetaDataEntryManager {
    private Map<String, MetaDataEntryProcessor> processors = new HashMap<String, MetaDataEntryProcessor>();

    protected void registerProcessor(MetaDataEntryProcessor processor) {
        this.processors.put(processor.getEntryName(), processor);
    }

    @Override
    public Class<? extends MetaDataEntry> getMetaDataEntryClass(String entryName) {
        MetaDataEntryProcessor processor = this.getProcessorForEntry(entryName);
        if (processor != null) {
            return processor.getEntryClass();
        }
        return null;
    }

    @Override
    public MetaDataEntryProcessor getProcessorForEntry(MetaDataEntry entry) {
        return this.getProcessorForEntry(entry.getName());
    }

    @Override
    public MetaDataEntryProcessor getProcessorForEntry(String entryName) {
        return this.processors.get(entryName);
    }
}

