/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.collections;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public abstract class ListView<SOURCE, VIEW>
extends AbstractList<VIEW> {
    protected abstract List<SOURCE> getDelegate();

    @Override
    public VIEW get(int index) {
        return this.toView(this.getDelegate().get(index));
    }

    @Override
    public int size() {
        return this.getDelegate().size();
    }

    @Override
    public boolean add(VIEW e) {
        return this.getDelegate().add(this.createSource(e));
    }

    @Override
    public VIEW set(int index, VIEW element) {
        return this.toView(this.getDelegate().set(index, this.createSource(element)));
    }

    @Override
    public void add(int index, VIEW element) {
        this.getDelegate().add(index, this.createSource(element));
    }

    @Override
    public VIEW remove(int index) {
        return this.toView(this.getDelegate().remove(index));
    }

    @Override
    public void clear() {
        this.getDelegate().clear();
    }

    @Override
    public Iterator<VIEW> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<VIEW> listIterator() {
        return new ListViewIterator(this.getDelegate().listIterator());
    }

    @Override
    public ListIterator<VIEW> listIterator(int index) {
        return new ListViewIterator(this.getDelegate().listIterator(index));
    }

    protected abstract VIEW toView(SOURCE var1);

    protected abstract SOURCE createSource(VIEW var1);

    protected class ListViewIterator
    implements ListIterator<VIEW> {
        private ListIterator<SOURCE> delegate;

        public ListViewIterator(ListIterator<SOURCE> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public VIEW next() {
            return ListView.this.toView(this.delegate.next());
        }

        @Override
        public boolean hasPrevious() {
            return this.delegate.hasPrevious();
        }

        @Override
        public VIEW previous() {
            return ListView.this.toView(this.delegate.previous());
        }

        @Override
        public int nextIndex() {
            return this.delegate.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.delegate.previousIndex();
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }

        @Override
        public void set(VIEW e) {
            this.delegate.set(ListView.this.createSource(e));
        }

        @Override
        public void add(VIEW e) {
            this.delegate.add(ListView.this.createSource(e));
        }
    }
}

