/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.system.configuration;

import java.nio.file.Path;
import org.jboss.weld.environment.se.Weld;
import org.kie.workbench.common.migration.cli.ContainerHandler;
import org.kie.workbench.common.migration.cli.MigrationSetup;
import org.kie.workbench.common.migration.cli.MigrationTool;
import org.kie.workbench.common.migration.cli.SystemAccess;
import org.kie.workbench.common.migration.cli.ToolConfig;
import org.kie.workbench.common.project.cli.PromptService;
import org.kie.workbench.common.system.configuration.ConfigGroupsMigrationService;

public class SystemConfigurationMigrationTool
implements MigrationTool {
    public static final String NAME = "System configuration directory structure migration";
    private SystemAccess system;
    private ToolConfig config;

    public String getTitle() {
        return NAME;
    }

    public String getDescription() {
        return "Moves old system configuration directory structure to the new one";
    }

    public Integer getPriority() {
        return 1;
    }

    public boolean isSystemMigration() {
        return true;
    }

    public void run(ToolConfig config, SystemAccess system) {
        this.config = config;
        this.system = system;
        PromptService promptService = new PromptService(system, config);
        system.out().println("Starting system configuration directory structure migration");
        if (this.validateTarget() && promptService.maybePromptForBackup()) {
            Path niogitDir = config.getTarget();
            MigrationSetup.configureProperties((SystemAccess)system, (Path)niogitDir);
            this.migrate();
        }
    }

    private void migrate() {
        ContainerHandler container = new ContainerHandler(() -> new Weld().initialize());
        container.run(ConfigGroupsMigrationService.class, service -> service.groupSystemConfigGroups(), error -> {
            this.system.err().println("Error during migration: ");
            error.printStackTrace(this.system.err());
        });
    }

    private boolean validateTarget() {
        if (!this.config.getTarget().resolve("system").resolve("system.git").toFile().exists()) {
            this.system.err().println(String.format("The PROJECT STRUCTURE MIGRATION must be ran before this one.", new Object[0]));
            return false;
        }
        return true;
    }
}

