/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.registry.inmemory.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class PageSortUtil {
    public static <T> List<T> pageSort(Collection<T> values, Comparator<T> comparator, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        if (page < 0) {
            throw new IllegalStateException("Page must be greater or equals than 0");
        }
        if (pageSize < 1) {
            throw new IllegalStateException("PageSize must be greater than 0");
        }
        if (page == 0 && values.size() <= pageSize) {
            ArrayList<T> result = new ArrayList<T>(values);
            PageSortUtil.sort(result, comparator, sort, sortOrder);
            return result;
        }
        if (values.size() <= pageSize * page) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList(pageSize);
        ArrayList<T> allValues = new ArrayList<T>(values);
        for (int i = page * pageSize; i < page * pageSize + pageSize; ++i) {
            if (allValues.size() <= i) continue;
            result.add(allValues.get(i));
        }
        PageSortUtil.sort(result, comparator, sort, sortOrder);
        return result;
    }

    private static <T> void sort(List<T> list, Comparator<T> comparator, String sort, boolean sortOrder) {
        if (sort != null && !sort.equals("")) {
            list.sort(comparator);
            if (!sortOrder) {
                Collections.reverse(list);
            }
        }
    }
}

