/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.infinispan.proto;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.infinispan.protostream.MessageMarshaller;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.JavaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.ext.metadata.backend.infinispan.utils.AttributesUtil;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.model.KProperty;
import org.uberfire.ext.metadata.model.impl.KObjectImpl;
import org.uberfire.ext.metadata.model.impl.KPropertyImpl;
import org.uberfire.java.nio.base.version.VersionHistory;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.java.nio.file.attribute.FileTime;

public class KObjectMarshaller
implements MessageMarshaller<KObject> {
    private Logger logger = LoggerFactory.getLogger(KObjectMarshaller.class);
    private static final String CLUSTER_ID = AttributesUtil.toProtobufFormat("cluster.id");
    private static final String SEGMENT_ID = AttributesUtil.toProtobufFormat("segment.id");
    private String typeName;
    private final List<String> mainAttributes = Arrays.asList("id", "type", CLUSTER_ID, SEGMENT_ID, "key", "fullText");

    public KObjectMarshaller(String typeName) {
        this.typeName = typeName;
    }

    public KObjectImpl readFrom(MessageMarshaller.ProtoStreamReader protoStreamReader) throws IOException {
        Descriptor descriptor = protoStreamReader.getSerializationContext().getMessageDescriptor(this.getTypeName());
        List<KProperty<?>> properties = descriptor.getFields().stream().filter(fieldDescriptor -> this.isExtension(descriptor.getName())).map(field -> new KPropertyImpl(AttributesUtil.toKPropertyFormat(field.getName()), this.read((FieldDescriptor)field, protoStreamReader), false)).collect(Collectors.toList());
        String id = this.getAndRemove(properties, "id");
        String type = this.getAndRemove(properties, "type");
        String clusterId = this.getAndRemove(properties, "cluster.id");
        String segmentId = this.getAndRemove(properties, "segment.id");
        String key = this.getAndRemove(properties, "key");
        String fullText = this.getAndRemove(properties, "fullText");
        return new KObjectImpl(id, type, clusterId, segmentId, key, properties, !StringUtils.isEmpty((CharSequence)fullText));
    }

    private String getAndRemove(List<KProperty<?>> properties, String key) {
        KProperty value = properties.stream().filter(kProperty -> kProperty.getName().equals(key)).findFirst().get();
        properties.remove(value);
        return (String)value.getValue();
    }

    public void writeTo(MessageMarshaller.ProtoStreamWriter protoStreamWriter, KObject kObject) throws IOException {
        Descriptor descriptor = protoStreamWriter.getSerializationContext().getMessageDescriptor(this.getTypeName());
        TreeMap props = new TreeMap();
        this.addKProperty(props, descriptor, "id", kObject.getId());
        this.addKProperty(props, descriptor, "type", kObject.getType().getName());
        this.addKProperty(props, descriptor, CLUSTER_ID, kObject.getClusterId());
        this.addKProperty(props, descriptor, SEGMENT_ID, kObject.getSegmentId());
        this.addKProperty(props, descriptor, "key", kObject.getKey());
        kObject.getProperties().iterator().forEachRemaining(kprop -> Optional.ofNullable(descriptor.findFieldByName(AttributesUtil.toProtobufFormat(kprop.getName()))).ifPresent(field -> props.putIfAbsent(field.getNumber(), (KProperty<?>)kprop)));
        if (kObject.fullText()) {
            this.addKProperty(props, descriptor, "fullText", props.values().stream().filter(kProperty -> kProperty.isSearchable() && !(kProperty.getValue() instanceof Boolean)).map(kProperty -> String.valueOf(kProperty.getValue()).toLowerCase()).collect(Collectors.joining("\n")));
        }
        props.keySet().forEach(number -> {
            try {
                KProperty kProperty = (KProperty)props.get(number);
                this.writeField(AttributesUtil.toProtobufFormat(kProperty.getName()), kProperty.getValue(), protoStreamWriter);
            }
            catch (IOException e) {
                this.logger.error("error", (Throwable)e);
            }
        });
    }

    public Class<? extends KObjectImpl> getJavaClass() {
        return KObjectImpl.class;
    }

    public String getTypeName() {
        return this.typeName;
    }

    private void writeField(String name, Object value, MessageMarshaller.ProtoStreamWriter writer) throws IOException {
        Class<?> aClass = value.getClass();
        if (Enum.class.isAssignableFrom(aClass)) {
            writer.writeString(name, value.toString());
        }
        if (aClass == String.class) {
            writer.writeString(name, value.toString());
        }
        if (aClass == Boolean.class) {
            writer.writeBoolean(name, (Boolean)value);
        }
        if (aClass == Integer.class) {
            writer.writeInt(name, (Integer)value);
        }
        if (aClass == Double.class) {
            writer.writeDouble(name, (Double)value);
        }
        if (aClass == Long.class) {
            writer.writeLong(name, (Long)value);
        }
        if (aClass == Float.class) {
            writer.writeFloat(name, (Float)value);
        }
        if (FileTime.class.isAssignableFrom(aClass)) {
            writer.writeLong(name, ((FileTime)value).toMillis());
        }
        if (Date.class.isAssignableFrom(aClass)) {
            writer.writeLong(name, ((Date)value).getTime());
        }
        if (VersionHistory.class.isAssignableFrom(aClass)) {
            this.writeField((VersionHistory)value, writer);
        }
        if (Collection.class.isAssignableFrom(aClass)) {
            StringBuilder sb = new StringBuilder();
            for (Object oValue : (Collection)value) {
                sb.append(oValue).append(' ');
            }
            writer.writeString(name, sb.toString());
        }
    }

    private void writeField(VersionHistory versionHistory, MessageMarshaller.ProtoStreamWriter writer) throws IOException {
        if (versionHistory.records().size() != 0) {
            int lastIndex = versionHistory.records().size() - 1;
            this.writeField("checkinComment", ((VersionRecord)versionHistory.records().get(lastIndex)).comment(), writer);
            this.writeField("createdBy", ((VersionRecord)versionHistory.records().get(0)).author(), writer);
            this.writeField("createdDate", ((VersionRecord)versionHistory.records().get(0)).date(), writer);
            this.writeField("lastModifiedBy", ((VersionRecord)versionHistory.records().get(lastIndex)).author(), writer);
            this.writeField("lastModifiedDate", ((VersionRecord)versionHistory.records().get(lastIndex)).date(), writer);
        }
    }

    private Object read(FieldDescriptor field, MessageMarshaller.ProtoStreamReader protoStreamReader) {
        JavaType javaType = field.getJavaType();
        try {
            if (JavaType.INT.equals((Object)javaType)) {
                return protoStreamReader.readInt(field.getName());
            }
            if (JavaType.BOOLEAN.equals((Object)javaType)) {
                return protoStreamReader.readBoolean(field.getName());
            }
            if (JavaType.DOUBLE.equals((Object)javaType)) {
                return protoStreamReader.readDouble(field.getName());
            }
            if (JavaType.FLOAT.equals((Object)javaType)) {
                return protoStreamReader.readFloat(field.getName());
            }
            if (JavaType.LONG.equals((Object)javaType)) {
                return protoStreamReader.readLong(field.getName());
            }
            return protoStreamReader.readString(field.getName());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private KProperty<?> addKProperty(Map<Integer, KProperty<?>> props, Descriptor descriptor, String key, String value) {
        return (KProperty)props.put(descriptor.findFieldByName(AttributesUtil.toProtobufFormat(key)).getNumber(), (KProperty<?>)new KPropertyImpl(key, (Object)value, false));
    }

    private boolean isExtension(String name) {
        return !this.getMainAttributes().contains(name);
    }

    private List<String> getMainAttributes() {
        return this.mainAttributes;
    }
}

