/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.m2repo.backend.server.repositories;

import java.io.File;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.guvnor.m2repo.backend.server.repositories.ArtifactRepository;
import org.guvnor.m2repo.backend.server.repositories.DistributionManagementArtifactRepository;
import org.guvnor.m2repo.backend.server.repositories.FileSystemArtifactRepository;
import org.guvnor.m2repo.backend.server.repositories.LocalArtifactRepository;
import org.guvnor.m2repo.backend.server.repositories.NullArtifactRepository;
import org.guvnor.m2repo.backend.server.repositories.Repository;
import org.guvnor.m2repo.preferences.ArtifactRepositoryPreference;
import org.uberfire.apache.commons.io.FilenameUtils;
import org.uberfire.backend.server.cdi.workspace.WorkspaceNameResolver;
import org.uberfire.backend.server.cdi.workspace.WorkspaceScoped;

@ApplicationScoped
public class ArtifactRepositoryProducer {
    private ArtifactRepositoryPreference preferences;
    private WorkspaceNameResolver workspaceNameResolver;

    public ArtifactRepositoryProducer() {
    }

    @Inject
    public ArtifactRepositoryProducer(ArtifactRepositoryPreference preferences, WorkspaceNameResolver resolver) {
        this.preferences = preferences;
        this.workspaceNameResolver = resolver;
    }

    @PostConstruct
    public void initialize() {
        this.preferences.load();
    }

    @Produces
    @Repository
    @ApplicationScoped
    public ArtifactRepository produceLocalRepository() {
        return new LocalArtifactRepository("local-m2-repo");
    }

    @Produces
    @Repository
    @ApplicationScoped
    public ArtifactRepository produceGlobalRepository() {
        if (!this.preferences.isGlobalM2RepoDirEnabled()) {
            return new NullArtifactRepository();
        }
        return new FileSystemArtifactRepository("global-m2-repo", this.getGlobalM2RepoDir());
    }

    @Produces
    @Repository
    @WorkspaceScoped
    public ArtifactRepository produceWorkspaceRepository() {
        if (!this.preferences.isWorkspaceM2RepoDirEnabled()) {
            return new NullArtifactRepository();
        }
        String repoDir = this.getWorkspaceRepoDir();
        return new FileSystemArtifactRepository("workspace-m2-repo", repoDir);
    }

    @Produces
    @Repository
    @ApplicationScoped
    public ArtifactRepository produceDistributionManagementRepository() {
        if (!this.preferences.isDistributionManagementM2RepoDirEnabled()) {
            return new NullArtifactRepository();
        }
        return new DistributionManagementArtifactRepository("distribution-management-repo");
    }

    private String getGlobalM2RepoDir() {
        String repoRoot = FilenameUtils.separatorsToSystem((String)this.preferences.getGlobalM2RepoDir());
        String meReposDir = System.getProperty("org.guvnor.m2repo.dir");
        String repoDir = meReposDir == null || meReposDir.trim().isEmpty() ? repoRoot : meReposDir.trim();
        return repoDir;
    }

    private String getWorkspaceRepoDir() {
        String workspace = this.getWorkspaceName();
        String repoRoot = FilenameUtils.separatorsToSystem((String)this.preferences.getWorkspaceM2RepoDir());
        String repoDir = repoRoot == null || repoRoot.trim().isEmpty() ? this.getGlobalM2RepoDir() + File.separator + "workspaces" : repoRoot;
        return repoDir + File.separator + workspace;
    }

    private String getWorkspaceName() {
        return this.workspaceNameResolver.getWorkspaceName();
    }
}

