/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl;

import java.io.StringWriter;

final class IndentWriter
extends StringWriter {
    private static final String TAB = "   ";
    private int indent = 0;
    private boolean indentNeeded = false;

    IndentWriter() {
    }

    public void inc() {
        ++this.indent;
    }

    public void dec() {
        if (this.indent > 0) {
            --this.indent;
        }
    }

    @Override
    public void write(int c) {
        if (this.indentNeeded) {
            this.indentNeeded = false;
            for (int i = 0; i < this.indent; ++i) {
                super.write(TAB);
            }
        }
        super.write(c);
        if (c == 10) {
            this.indentNeeded = true;
        }
    }

    @Override
    public void write(char[] buf, int off, int len) {
        for (int i = off; i < off + len; ++i) {
            this.write(buf[i]);
        }
    }

    @Override
    public void write(String s) {
        if (s == null) {
            s = "null";
        }
        this.write(s, 0, s.length());
    }

    @Override
    public void write(String s, int off, int len) {
        for (int i = off; i < off + len; ++i) {
            this.write(s.charAt(i));
        }
    }
}

