/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class ClusterTopologyChangeMessage
extends PacketImpl {
    protected boolean exit;
    protected String nodeID;
    protected Pair<TransportConfiguration, TransportConfiguration> pair;
    protected boolean last;

    public ClusterTopologyChangeMessage(String nodeID, Pair<TransportConfiguration, TransportConfiguration> pair, boolean last) {
        super((byte)110);
        this.nodeID = nodeID;
        this.pair = pair;
        this.last = last;
        this.exit = false;
    }

    public ClusterTopologyChangeMessage(String nodeID) {
        super((byte)110);
        this.exit = true;
        this.nodeID = nodeID;
    }

    public ClusterTopologyChangeMessage() {
        super((byte)110);
    }

    public ClusterTopologyChangeMessage(byte clusterTopologyV2) {
        super(clusterTopologyV2);
    }

    public String getNodeID() {
        return this.nodeID;
    }

    public Pair<TransportConfiguration, TransportConfiguration> getPair() {
        return this.pair;
    }

    public boolean isLast() {
        return this.last;
    }

    public boolean isExit() {
        return this.exit;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeBoolean(this.exit);
        buffer.writeString(this.nodeID);
        if (!this.exit) {
            if (this.pair.getA() != null) {
                buffer.writeBoolean(true);
                ((TransportConfiguration)this.pair.getA()).encode(buffer);
            } else {
                buffer.writeBoolean(false);
            }
            if (this.pair.getB() != null) {
                buffer.writeBoolean(true);
                ((TransportConfiguration)this.pair.getB()).encode(buffer);
            } else {
                buffer.writeBoolean(false);
            }
            buffer.writeBoolean(this.last);
        }
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.exit = buffer.readBoolean();
        this.nodeID = buffer.readString();
        if (!this.exit) {
            TransportConfiguration b;
            TransportConfiguration a;
            boolean hasLive = buffer.readBoolean();
            if (hasLive) {
                a = new TransportConfiguration();
                a.decode(buffer);
            } else {
                a = null;
            }
            boolean hasBackup = buffer.readBoolean();
            if (hasBackup) {
                b = new TransportConfiguration();
                b.decode(buffer);
            } else {
                b = null;
            }
            this.pair = new Pair((Object)a, (Object)b);
            this.last = buffer.readBoolean();
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.exit ? 1231 : 1237);
        result = 31 * result + (this.last ? 1231 : 1237);
        result = 31 * result + (this.nodeID == null ? 0 : this.nodeID.hashCode());
        result = 31 * result + (this.pair == null ? 0 : this.pair.hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer(this.getParentString());
        buff.append(", exit=" + this.exit);
        buff.append(", last=" + this.last);
        buff.append(", nodeID=" + this.nodeID);
        buff.append(", pair=" + this.pair);
        buff.append("]");
        return buff.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ClusterTopologyChangeMessage)) {
            return false;
        }
        ClusterTopologyChangeMessage other = (ClusterTopologyChangeMessage)obj;
        if (this.exit != other.exit) {
            return false;
        }
        if (this.last != other.last) {
            return false;
        }
        if (this.nodeID == null ? other.nodeID != null : !this.nodeID.equals(other.nodeID)) {
            return false;
        }
        return !(this.pair == null ? other.pair != null : !this.pair.equals(other.pair));
    }
}

