/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.descriptors;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.config.AnnotationConfiguration;
import org.infinispan.protostream.descriptors.AnnotatedDescriptor;
import org.infinispan.protostream.descriptors.AnnotationElement;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.EnumDescriptor;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.descriptors.JavaType;
import org.infinispan.protostream.descriptors.Label;
import org.infinispan.protostream.descriptors.Option;
import org.infinispan.protostream.descriptors.Type;
import org.infinispan.protostream.impl.AnnotatedDescriptorImpl;

public final class FieldDescriptor
extends AnnotatedDescriptorImpl
implements AnnotatedDescriptor {
    private static final String PACKED = "packed";
    private final int number;
    private final Label label;
    private final List<Option> options;
    private final String typeName;
    private final String defaultValue;
    private final Map<String, Object> optionByName = new HashMap<String, Object>();
    private final boolean isExtension;
    private Type type;
    private FileDescriptor fileDescriptor;
    private Descriptor containingMessage;
    private Descriptor messageType;
    private EnumDescriptor enumType;

    private FieldDescriptor(Builder builder) {
        super(builder.name, null, builder.documentation);
        this.number = builder.number;
        this.label = builder.label;
        this.options = Collections.unmodifiableList(builder.options);
        for (Option opt : this.options) {
            this.optionByName.put(opt.getName(), opt.getValue());
        }
        this.typeName = builder.typeName;
        this.defaultValue = builder.defaultValue;
        this.isExtension = builder.isExtension;
    }

    public int getNumber() {
        return this.number;
    }

    public Type getType() {
        return this.type;
    }

    void setType(Type type) {
        this.type = type;
    }

    public Descriptor getMessageType() {
        return this.messageType;
    }

    public Label getLabel() {
        return this.label;
    }

    public Object getOptionByName(String name) {
        return this.optionByName.get(name);
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public Option getOption(String name) {
        for (Option o : this.options) {
            if (!o.getName().equals(name)) continue;
            return o;
        }
        return null;
    }

    public boolean isRequired() {
        return this.label == Label.REQUIRED;
    }

    public boolean isRepeated() {
        return this.label == Label.REPEATED;
    }

    public boolean isPacked() {
        return this.optionByName.containsKey(PACKED);
    }

    public Object getDefaultValue() {
        if (!this.hasDefaultValue()) {
            return null;
        }
        if (!this.getJavaType().isScalar()) {
            throw new UnsupportedOperationException("FieldDescriptor.getDefaultValue() called on an embedded message field (only scalars can have a default value).");
        }
        return this.getJavaType().fromString(this.defaultValue);
    }

    public boolean isExtension() {
        return this.isExtension;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public JavaType getJavaType() {
        return this.getType().getJavaType();
    }

    public EnumDescriptor getEnumType() {
        return this.enumType;
    }

    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public FileDescriptor getFileDescriptor() {
        return this.fileDescriptor;
    }

    public Descriptor getContainingMessage() {
        return this.containingMessage;
    }

    void setContainingMessage(Descriptor containingMessage) {
        this.containingMessage = containingMessage;
        this.fullName = containingMessage.getFullName() + '.' + this.name;
    }

    void setMessageType(Descriptor descriptor) {
        this.messageType = descriptor;
        this.type = Type.MESSAGE;
    }

    void setEnumType(EnumDescriptor enumDescriptor) {
        this.enumType = enumDescriptor;
        this.type = Type.ENUM;
    }

    void setFileDescriptor(FileDescriptor fileDescriptor) {
        this.fileDescriptor = fileDescriptor;
    }

    @Override
    protected AnnotationConfiguration getAnnotationConfig(String annotationName) {
        AnnotationConfiguration annotationConfiguration = this.getAnnotationsConfig().annotations().get(annotationName);
        if (annotationConfiguration == null) {
            return null;
        }
        for (AnnotationElement.AnnotationTarget t : annotationConfiguration.target()) {
            if (t != AnnotationElement.AnnotationTarget.FIELD) continue;
            return annotationConfiguration;
        }
        throw new DescriptorParserException("Annotation '" + annotationName + "' cannot be applied to fields.");
    }

    public String toString() {
        return "FieldDescriptor{label=" + (Object)((Object)this.label) + ", typeName='" + this.typeName + '\'' + ", name='" + this.name + '\'' + ", number='" + this.number + '\'' + ", defaultValue=" + this.defaultValue + '}';
    }

    public static final class Builder {
        private String typeName;
        private int number;
        private String name;
        private Label label;
        private List<Option> options;
        private String defaultValue;
        private boolean isExtension;
        private String documentation;

        public Builder withNumber(int number) {
            this.number = number;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withTypeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public Builder withLabel(Label label) {
            this.label = label;
            return this;
        }

        public Builder withOptions(List<Option> options) {
            this.options = options;
            return this;
        }

        public Builder withDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder withIsExtension(boolean isExtension) {
            this.isExtension = isExtension;
            return this;
        }

        public Builder withDocumentation(String documentation) {
            this.documentation = documentation;
            return this;
        }

        public FieldDescriptor build() {
            FieldDescriptor fieldDescriptor = new FieldDescriptor(this);
            try {
                Type fieldType = Type.valueOf(this.typeName.toUpperCase());
                fieldDescriptor.setType(fieldType);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return fieldDescriptor;
        }
    }
}

