/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.dataconversion;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;

public abstract class OneToManyTranscoder
implements Transcoder {
    private MediaType mainType;
    protected final Set<MediaType> supportedTypes = new HashSet<MediaType>();

    public OneToManyTranscoder(MediaType mainType, MediaType ... supportedConversions) {
        this.mainType = mainType;
        this.supportedTypes.add(mainType);
        this.supportedTypes.addAll(Arrays.asList(supportedConversions));
    }

    private boolean in(MediaType mediaType, Set<MediaType> set) {
        return set.stream().anyMatch(s -> s.match(mediaType));
    }

    @Override
    public Set<MediaType> getSupportedMediaTypes() {
        return this.supportedTypes;
    }

    @Override
    public boolean supportsConversion(MediaType mediaType, MediaType other) {
        return mediaType.match(this.mainType) && this.in(other, this.supportedTypes) || other.match(this.mainType) && this.in(mediaType, this.supportedTypes);
    }
}

