/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ancompiler;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.comments.LineComment;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.LongLiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.BreakStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ForEachStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.stmt.SwitchEntry;
import com.github.javaparser.ast.stmt.SwitchStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.VoidType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.ancompiler.AbstractCompilerHandler;
import org.drools.ancompiler.CouldNotCreateAlphaNetworkCompilerException;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.WindowNode;
import org.drools.core.rule.IndexableConstraint;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.StringUtils;
import org.drools.core.util.index.AlphaRangeIndex;

public abstract class PropagatorCompilerHandler
extends AbstractCompilerHandler {
    protected final boolean alphaNetContainsHashedField;
    protected final String factClassName;
    protected static final String FACT_HANDLE_PARAM_NAME = "handle";
    protected static final String PROP_CONTEXT_PARAM_NAME = "context";
    protected static final String WORKING_MEMORY_PARAM_NAME = "wm";
    protected static final String MODIFY_PREVIOUS_TUPLE_PARAM_NAME = "modifyPreviousTuples";
    protected static final String LOCAL_FACT_VAR_NAME = "fact";
    private Class<?> fieldType;
    protected BlockStmt allStatements = new BlockStmt();
    protected Deque<Node> currentStatement = new ArrayDeque<Node>();
    protected List<MethodDeclaration> extractedMethods = new ArrayList<MethodDeclaration>();

    protected PropagatorCompilerHandler(boolean alphaNetContainsHashedField, String factClassName) {
        this.alphaNetContainsHashedField = alphaNetContainsHashedField;
        this.factClassName = factClassName;
        this.currentStatement.push((Node)this.allStatements);
    }

    protected abstract Statement propagateMethod(Sink var1);

    protected abstract NodeList<Parameter> methodParameters();

    protected abstract NodeList<Expression> arguments();

    @Override
    public void startObjectTypeNode(ObjectTypeNode objectTypeNode) {
        if (this.alphaNetContainsHashedField) {
            ClassOrInterfaceType type = StaticJavaParser.parseClassOrInterfaceType((String)this.factClassName);
            ExpressionStmt factVariable = this.localVariableWithCastInitializer((Type)type, LOCAL_FACT_VAR_NAME, new MethodCallExpr((Expression)new NameExpr(FACT_HANDLE_PARAM_NAME), "getObject"));
            this.getCurrentBlockStatement().addStatement((Statement)factVariable);
        }
    }

    @Override
    public void startBetaNode(BetaNode betaNode) {
        this.getCurrentBlockStatement().addStatement(this.propagateMethod((Sink)betaNode));
    }

    @Override
    public void startWindowNode(WindowNode windowNode) {
        this.getCurrentBlockStatement().addStatement(this.propagateMethod((Sink)windowNode));
    }

    @Override
    public void startLeftInputAdapterNode(LeftInputAdapterNode leftInputAdapterNode) {
        this.getCurrentBlockStatement().addStatement(this.propagateMethod((Sink)leftInputAdapterNode));
    }

    @Override
    public void startNonHashedAlphaNode(AlphaNode alphaNode) {
        IfStmt ifStatement = StaticJavaParser.parseStatement((String)"if (CONSTRAINT.isAllowed(handle, wm)) { }").asIfStmt();
        this.replaceNameExpr((Node)ifStatement, "CONSTRAINT", PropagatorCompilerHandler.getVariableName(alphaNode));
        this.getCurrentBlockStatement().addStatement((Statement)ifStatement);
        this.currentStatement.push((Node)ifStatement);
    }

    @Override
    public void endNonHashedAlphaNode(AlphaNode alphaNode) {
        this.currentStatement.pop();
    }

    @Override
    public void startHashedAlphaNodes(IndexableConstraint indexableConstraint) {
        Object nullCheck;
        SwitchStmt switchStmt;
        InternalReadAccessor fieldExtractor = indexableConstraint.getFieldExtractor();
        this.fieldType = fieldExtractor.getExtractToClass();
        if (this.canInlineValue(this.fieldType)) {
            String switchVariableName = "switchVar";
            ExpressionStmt switchVariable = this.localVariableWithCastInitializer(StaticJavaParser.parseType((String)this.fieldType.getCanonicalName()), switchVariableName, (MethodCallExpr)StaticJavaParser.parseExpression((String)"readAccessor.getValue(fact)"));
            this.allStatements.addStatement((Statement)switchVariable);
            switchStmt = new SwitchStmt().setSelector((Expression)new NameExpr(switchVariableName));
            nullCheck = this.fieldType.isPrimitive() ? (Statement)new BlockStmt().addStatement((Statement)switchStmt) : new IfStmt().setCondition((Expression)new BinaryExpr((Expression)new NameExpr(switchVariableName), (Expression)new NullLiteralExpr(), BinaryExpr.Operator.NOT_EQUALS)).setThenStmt((Statement)switchStmt);
        } else {
            String localVariableName = "NodeId";
            ExpressionStmt expressionStmt = this.localVariableWithCastInitializer(StaticJavaParser.parseType((String)"java.lang.Integer"), localVariableName, (MethodCallExpr)StaticJavaParser.parseExpression((String)"ToNodeId.get(readAccessor.getValue(fact))"));
            this.allStatements.addStatement((Statement)expressionStmt);
            switchStmt = new SwitchStmt().setSelector((Expression)new MethodCallExpr((Expression)new NameExpr(localVariableName), "intValue", NodeList.nodeList((Node[])new Expression[0])));
            nullCheck = new IfStmt().setCondition((Expression)new BinaryExpr((Expression)new NameExpr(localVariableName), (Expression)new NullLiteralExpr(), BinaryExpr.Operator.NOT_EQUALS)).setThenStmt((Statement)switchStmt);
        }
        this.allStatements.addStatement(nullCheck);
        this.currentStatement.push((Node)switchStmt);
    }

    protected boolean canInlineValue(Class<?> fieldType) {
        return Stream.of(String.class, Integer.class, Integer.TYPE).anyMatch(c -> c.isAssignableFrom(fieldType));
    }

    @Override
    public void startHashedAlphaNode(AlphaNode hashedAlpha, Object hashedValue) {
        SwitchEntry newSwitchEntry = new SwitchEntry();
        if (this.canInlineValue(this.fieldType)) {
            Object quotedHashedValue = hashedValue instanceof String ? new StringLiteralExpr((String)hashedValue) : (hashedValue instanceof Long ? new LongLiteralExpr(((Long)hashedValue).longValue()) : new IntegerLiteralExpr(((Integer)hashedValue).intValue()));
            newSwitchEntry.setLabels(NodeList.nodeList((Node[])new Expression[]{quotedHashedValue}));
        } else {
            newSwitchEntry.setLabels(NodeList.nodeList((Node[])new Expression[]{new IntegerLiteralExpr(hashedAlpha.getId())}));
        }
        this.addNewSwitchEntryToStack(newSwitchEntry);
    }

    @Override
    public void endHashedAlphaNode(AlphaNode hashedAlpha, Object hashedValue) {
        this.addBreakStatement(this.getLastSwitchEntry());
        this.currentStatement.pop();
    }

    @Override
    public void startRangeIndex(AlphaRangeIndex alphaRangeIndex) {
        String rangeIndexVariableName = this.getRangeIndexVariableName(alphaRangeIndex, this.getMinIdFromRangeIndex(alphaRangeIndex));
        String matchingResultVariableName = rangeIndexVariableName + "_result";
        String matchingNodeVariableName = matchingResultVariableName + "_node";
        ExpressionStmt matchingResultVariable = this.localVariable(StaticJavaParser.parseType((String)"java.util.Collection<org.drools.core.reteoo.AlphaNode>"), matchingResultVariableName, new MethodCallExpr((Expression)new NameExpr(rangeIndexVariableName), "getMatchingAlphaNodes", NodeList.nodeList((Node[])new Expression[]{new MethodCallExpr((Expression)new NameExpr(FACT_HANDLE_PARAM_NAME), "getObject")})));
        BlockStmt currentBlockStatement = this.getCurrentBlockStatement();
        currentBlockStatement.addStatement((Statement)matchingResultVariable);
        BlockStmt body = new BlockStmt();
        ForEachStmt forEachStmt = new ForEachStmt(new VariableDeclarationExpr(StaticJavaParser.parseType((String)"org.drools.core.reteoo.AlphaNode"), matchingNodeVariableName), (Expression)new NameExpr(matchingResultVariableName), (Statement)body);
        currentBlockStatement.addStatement((Statement)forEachStmt);
        SwitchStmt switchStatement = new SwitchStmt().setSelector((Expression)new MethodCallExpr((Expression)new NameExpr(matchingNodeVariableName), "getId"));
        this.currentStatement.push((Node)switchStatement);
        body.addStatement((Statement)switchStatement);
    }

    @Override
    public void startRangeIndexedAlphaNode(AlphaNode alphaNode) {
        SwitchEntry switchEntry = new SwitchEntry().setLabels(NodeList.nodeList((Node[])new Expression[]{new IntegerLiteralExpr(alphaNode.getId())}));
        this.addNewSwitchEntryToStack(switchEntry);
    }

    private void addNewSwitchEntryToStack(SwitchEntry switchEntry) {
        SwitchStmt currentSwitch = (SwitchStmt)this.currentStatement.getFirst();
        BlockStmt block = new BlockStmt();
        block.setParentNode((Node)switchEntry);
        this.currentStatement.push((Node)block);
        switchEntry.setStatements(NodeList.nodeList((Node[])new Statement[]{block}));
        currentSwitch.getEntries().add((Node)switchEntry);
    }

    @Override
    public void endRangeIndexedAlphaNode(AlphaNode alphaNode) {
        this.addBreakStatement(this.getLastSwitchEntry());
        this.currentStatement.pop();
    }

    public SwitchEntry getLastSwitchEntry() {
        return (SwitchEntry)this.currentStatement.getFirst().findAncestor(SwitchEntry.class).orElseThrow(() -> new CouldNotCreateAlphaNetworkCompilerException("No switch entry to break found"));
    }

    @Override
    public void endRangeIndex(AlphaRangeIndex alphaRangeIndex) {
        this.currentStatement.pop();
    }

    private void addBreakStatement(SwitchEntry switchEntry) {
        switchEntry.getStatements().add((Node)new BreakStmt().setValue(null));
    }

    public BlockStmt getCurrentBlockStatement() {
        if (this.currentStatement.getFirst() instanceof IfStmt) {
            return (BlockStmt)((IfStmt)this.currentStatement.getFirst()).getThenStmt();
        }
        return (BlockStmt)this.currentStatement.getFirst();
    }

    protected abstract String propagateMethodName();

    public String emitCode() {
        MethodDeclaration propagateMethod = ((MethodDeclaration)((MethodDeclaration)new MethodDeclaration().setModifiers(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC, Modifier.Keyword.FINAL})).setType((Type)new VoidType()).setName(this.propagateMethodName())).setParameters(this.methodParameters());
        BlockStmt body = new BlockStmt();
        propagateMethod.setBody(body);
        body.addStatement(StaticJavaParser.parseStatement((String)String.format("if(logger.isDebugEnabled()) {\n            logger.debug(\"%s on compiled alpha network {} {} {}\", handle, context, wm);\n        }\n", this.propagateMethodName())));
        this.postProcessAllStatements();
        for (Statement s : this.allStatements.getStatements()) {
            body.addStatement(s);
        }
        StringBuilder allCodeGenerated = new StringBuilder();
        allCodeGenerated.append(propagateMethod.toString());
        allCodeGenerated.append("\n");
        for (MethodDeclaration md : this.extractedMethods) {
            allCodeGenerated.append(md.toString());
            allCodeGenerated.append("\n");
            allCodeGenerated.append("\n");
        }
        return allCodeGenerated.toString();
    }

    private void postProcessAllStatements() {
        this.partitionSwitchEntries();
    }

    private void partitionSwitchEntries() {
        this.allStatements.findAll(SwitchEntry.class).forEach(this::extractMethod);
    }

    private void extractMethod(SwitchEntry switchEntry) {
        String label = switchEntry.getLabels().stream().map(Node::toString).collect(Collectors.joining());
        SwitchStmt switchStatement = (SwitchStmt)switchEntry.findAncestor(SwitchStmt.class).orElseThrow(() -> new CouldNotCreateAlphaNetworkCompilerException("SwitchEntry without SwitchStatement"));
        int index = switchStatement.getEntries().indexOf((Object)switchEntry);
        String selectorString = switchStatement.getSelector().toString();
        String newMethodName = String.format("extractedPropagated_%s_%d", StringUtils.md5Hash((String)selectorString), index);
        BlockStmt switchEntryStatements = (BlockStmt)switchEntry.getStatements().get(0);
        MethodDeclaration extractedMethod = ((MethodDeclaration)new MethodDeclaration().setModifiers(NodeList.nodeList((Node[])new Modifier[]{Modifier.publicModifier()})).setName(newMethodName)).setParameters(this.methodParameters()).setType((Type)new VoidType()).setBody(switchEntryStatements);
        extractedMethod.setComment((Comment)new LineComment(selectorString + " " + label));
        MethodCallExpr callExtractedMethod = ((MethodCallExpr)new MethodCallExpr().setName(newMethodName)).setArguments(this.arguments());
        switchEntry.setStatements(NodeList.nodeList((Node[])new Statement[]{new ExpressionStmt((Expression)callExtractedMethod), new BreakStmt().setValue(null)}));
        this.extractedMethods.add(extractedMethod);
    }

    public ClassOrInterfaceType modifyPreviousTuplesType() {
        return StaticJavaParser.parseClassOrInterfaceType((String)ModifyPreviousTuples.class.getCanonicalName());
    }

    public ClassOrInterfaceType factHandleType() {
        return StaticJavaParser.parseClassOrInterfaceType((String)InternalFactHandle.class.getCanonicalName());
    }

    public ClassOrInterfaceType propagationContextType() {
        return StaticJavaParser.parseClassOrInterfaceType((String)PropagationContext.class.getName());
    }

    public ClassOrInterfaceType workingMemoryType() {
        return StaticJavaParser.parseClassOrInterfaceType((String)InternalWorkingMemory.class.getName());
    }

    protected ExpressionStmt localVariableWithCastInitializer(Type type, String variableName, MethodCallExpr source) {
        return new ExpressionStmt((Expression)new VariableDeclarationExpr(new VariableDeclarator(type, variableName, (Expression)new CastExpr(type, (Expression)source))));
    }

    protected ExpressionStmt localVariable(Type type, String variableName, MethodCallExpr source) {
        return new ExpressionStmt((Expression)new VariableDeclarationExpr(new VariableDeclarator(type, variableName, (Expression)source)));
    }
}

