/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.explain;

import java.io.IOException;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.index.get.GetResult;

public class ExplainResponse
extends ActionResponse {
    private String index;
    private String type;
    private String id;
    private boolean exists;
    private Explanation explanation;
    private GetResult getResult;

    ExplainResponse() {
    }

    public ExplainResponse(String index, String type, String id, boolean exists) {
        this.index = index;
        this.type = type;
        this.id = id;
        this.exists = exists;
    }

    public ExplainResponse(String index, String type, String id, boolean exists, Explanation explanation) {
        this(index, type, id, exists);
        this.explanation = explanation;
    }

    public ExplainResponse(String index, String type, String id, boolean exists, Explanation explanation, GetResult getResult) {
        this(index, type, id, exists, explanation);
        this.getResult = getResult;
    }

    public String getIndex() {
        return this.index;
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public Explanation getExplanation() {
        return this.explanation;
    }

    public boolean isMatch() {
        return this.explanation != null && this.explanation.isMatch();
    }

    public boolean hasExplanation() {
        return this.explanation != null;
    }

    public boolean isExists() {
        return this.exists;
    }

    public GetResult getGetResult() {
        return this.getResult;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.index = in.readString();
        this.type = in.readString();
        this.id = in.readString();
        this.exists = in.readBoolean();
        if (in.readBoolean()) {
            this.explanation = Lucene.readExplanation(in);
        }
        if (in.readBoolean()) {
            this.getResult = GetResult.readGetResult(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.index);
        out.writeString(this.type);
        out.writeString(this.id);
        out.writeBoolean(this.exists);
        if (this.explanation == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Lucene.writeExplanation(out, this.explanation);
        }
        if (this.getResult == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.getResult.writeTo(out);
        }
    }
}

