/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reflective;

import java.io.IOException;
import org.drools.reflective.ComponentsSupplier;
import org.drools.reflective.ResourceProvider;
import org.drools.reflective.classloader.ProjectClassLoader;
import org.drools.reflective.util.ByteArrayClassLoader;
import org.kie.api.internal.utils.ServiceUtil;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.internal.builder.KnowledgeBuilder;

public class ComponentsFactory {
    private static final String DYNAMIC_IMPL = "org.drools.dynamic.DynamicComponentsSupplier";
    private static final String STATIC_IMPL = "org.drools.statics.StaticComponentsSupplier";
    private static ComponentsSupplier supplier;

    public static ProjectClassLoader createProjectClassLoader(ClassLoader parent, ResourceProvider resourceProvider) {
        return ComponentsFactory.getComponentsSupplier().createProjectClassLoader(parent, resourceProvider);
    }

    public static ByteArrayClassLoader createByteArrayClassLoader(ClassLoader parent) {
        return ComponentsFactory.getComponentsSupplier().createByteArrayClassLoader(parent);
    }

    public static Object createConsequenceExceptionHandler(String className, ClassLoader classLoader) {
        return ComponentsFactory.getComponentsSupplier().createConsequenceExceptionHandler(className, classLoader);
    }

    public static Object createTimerService(String className) {
        return ComponentsFactory.getComponentsSupplier().createTimerService(className);
    }

    public static void addPackageFromXSD(KnowledgeBuilder kBuilder, Resource resource, ResourceConfiguration configuration) throws IOException {
        ComponentsFactory.getComponentsSupplier().addPackageFromXSD(kBuilder, resource, configuration);
    }

    public static void setComponentsSupplier(ComponentsSupplier supplier) {
        ComponentsFactory.supplier = supplier;
    }

    private static ComponentsSupplier getComponentsSupplier() {
        if (supplier == null) {
            supplier = Holder.supplier;
        }
        return supplier;
    }

    private static class Holder {
        private static ComponentsSupplier supplier = (ComponentsSupplier)ServiceUtil.instanceFromNames((String[])new String[]{"org.drools.dynamic.DynamicComponentsSupplier", "org.drools.statics.StaticComponentsSupplier"});

        private Holder() {
        }
    }
}

