/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.metadata;

import java.security.AccessController;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jboss.weld.bootstrap.spi.ClassAvailableActivation;
import org.jboss.weld.bootstrap.spi.Filter;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.bootstrap.spi.SystemPropertyActivation;
import org.jboss.weld.bootstrap.spi.WeldFilter;
import org.jboss.weld.metadata.Selectors;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jboss.weld.security.GetSystemPropertyAction;

public class FilterPredicate
implements Predicate<String> {
    private final boolean active;
    private final Matcher matcher;

    public FilterPredicate(Metadata<Filter> filter, ResourceLoader resourceLoader) {
        boolean active = true;
        if (((Filter)filter.getValue()).getClassAvailableActivations() != null) {
            for (Metadata classAvailableActivation : ((Filter)filter.getValue()).getClassAvailableActivations()) {
                boolean inverted;
                if (classAvailableActivation.getValue() == null) {
                    throw new IllegalStateException("Class available activation metadata not available at " + classAvailableActivation);
                }
                String className = ((ClassAvailableActivation)classAvailableActivation.getValue()).getClassName();
                if (className == null) {
                    throw new IllegalStateException("Must specify class name at " + classAvailableActivation);
                }
                boolean bl = inverted = FilterPredicate.isInverted(className) || ((ClassAvailableActivation)classAvailableActivation.getValue()).isInverted();
                if (inverted) {
                    className = FilterPredicate.removeInversion(className);
                }
                active = active && FilterPredicate.isClassAvailable(className, resourceLoader, inverted);
            }
        }
        if (((Filter)filter.getValue()).getSystemPropertyActivations() != null) {
            for (Metadata systemPropertyActivation : ((Filter)filter.getValue()).getSystemPropertyActivations()) {
                if (systemPropertyActivation.getValue() == null) {
                    throw new IllegalStateException("System property activation metadata not available at " + systemPropertyActivation);
                }
                String propertyName = ((SystemPropertyActivation)systemPropertyActivation.getValue()).getName();
                String requiredPropertyValue = ((SystemPropertyActivation)systemPropertyActivation.getValue()).getValue();
                if (propertyName == null) {
                    throw new IllegalStateException("Must specify system property name at " + systemPropertyActivation);
                }
                boolean propertyNameInverted = FilterPredicate.isInverted(propertyName);
                if (propertyNameInverted && requiredPropertyValue != null) {
                    throw new IllegalStateException("Cannot invert property name and specify property value at " + systemPropertyActivation);
                }
                if (propertyNameInverted) {
                    propertyName = FilterPredicate.removeInversion(propertyName);
                }
                String actualPropertyValue = AccessController.doPrivileged(new GetSystemPropertyAction(propertyName));
                if (requiredPropertyValue == null) {
                    active = active && FilterPredicate.isNotNull(actualPropertyValue, propertyNameInverted);
                    continue;
                }
                boolean requiredPropertyValueInverted = FilterPredicate.isInverted(requiredPropertyValue);
                if (requiredPropertyValueInverted) {
                    requiredPropertyValue = FilterPredicate.removeInversion(requiredPropertyValue);
                }
                active = active && FilterPredicate.isEqual(requiredPropertyValue, actualPropertyValue, requiredPropertyValueInverted);
            }
        }
        this.active = active;
        if (filter.getValue() instanceof WeldFilter) {
            WeldFilter weldFilter = (WeldFilter)filter.getValue();
            if (weldFilter.getName() != null && weldFilter.getPattern() != null || weldFilter.getName() == null && weldFilter.getPattern() == null) {
                throw new IllegalStateException("Cannot specify both a pattern and a name at " + filter);
            }
            this.matcher = weldFilter.getPattern() != null ? new PatternMatcher(filter, weldFilter.getPattern()) : new AntSelectorMatcher(weldFilter.getName());
        } else {
            if (((Filter)filter.getValue()).getName() == null) {
                throw new IllegalStateException("Name must be specified at " + filter);
            }
            String name = ((Filter)filter.getValue()).getName();
            String suffixDotDoubleStar = ".**";
            String suffixDotStar = ".*";
            this.matcher = name.endsWith(suffixDotDoubleStar) ? new PrefixMatcher(name.substring(0, name.length() - suffixDotDoubleStar.length()), filter) : (name.endsWith(suffixDotStar) ? new PackageMatcher(name.substring(0, name.length() - suffixDotStar.length()), filter) : new FullyQualifierClassNameMatcher(name, filter));
        }
    }

    @Override
    public boolean test(String className) {
        if (this.active) {
            return this.matcher.matches(className);
        }
        return false;
    }

    private static boolean isClassAvailable(String className, ResourceLoader resourceLoader, boolean invert) {
        if (invert) {
            return !FilterPredicate.isClassAvailable(className, resourceLoader);
        }
        return FilterPredicate.isClassAvailable(className, resourceLoader);
    }

    private static boolean isClassAvailable(String className, ResourceLoader resourceLoader) {
        try {
            resourceLoader.classForName(className);
        }
        catch (ResourceLoadingException e) {
            return false;
        }
        return true;
    }

    private static boolean isNotNull(String string, boolean invert) {
        if (invert) {
            return string == null;
        }
        return string != null;
    }

    private static boolean isEqual(String string1, String string2, boolean invert) {
        if (invert) {
            return !string1.equals(string2);
        }
        return string1.equals(string2);
    }

    private static boolean isInverted(String string) {
        return string.startsWith("!");
    }

    private static String removeInversion(String string) {
        if (!string.startsWith("!")) {
            return string;
        }
        return string.substring(1);
    }

    private static class PackageMatcher
    extends CDI11Matcher {
        private PackageMatcher(String pkg, Metadata<Filter> filter) {
            super(pkg, filter);
        }

        @Override
        public boolean matches(String input) {
            if (input == null) {
                return false;
            }
            int lastDot = input.lastIndexOf(46);
            if (lastDot == -1) {
                return false;
            }
            return this.expression.equals(input.substring(0, lastDot));
        }
    }

    private static class PrefixMatcher
    extends CDI11Matcher {
        private PrefixMatcher(String prefix, Metadata<Filter> filter) {
            super(prefix, filter);
        }

        @Override
        public boolean matches(String input) {
            return input != null && input.startsWith(this.expression);
        }
    }

    private static class FullyQualifierClassNameMatcher
    extends CDI11Matcher {
        private FullyQualifierClassNameMatcher(String fqcn, Metadata<Filter> filter) {
            super(fqcn, filter);
        }

        @Override
        public boolean matches(String input) {
            return this.expression.equals(input);
        }
    }

    private static abstract class CDI11Matcher
    implements Matcher {
        private static final Pattern CDI11_EXCLUDE_PATTERN = Pattern.compile("([\\p{L}_$][\\p{L}\\p{N}_$]*\\.)*[\\p{L}_$][\\p{L}\\p{N}_$]*");
        protected final String expression;

        private CDI11Matcher(String expression, Metadata<Filter> filter) {
            this.expression = expression;
            if (!CDI11_EXCLUDE_PATTERN.matcher(expression).matches()) {
                throw new IllegalArgumentException("Invalid expression " + filter);
            }
        }
    }

    private static class AntSelectorMatcher
    implements Matcher {
        private final String name;

        private AntSelectorMatcher(String name) {
            this.name = name;
        }

        @Override
        public boolean matches(String input) {
            return Selectors.matchPath(this.name, input);
        }
    }

    private static class PatternMatcher
    implements Matcher {
        private final Pattern pattern;

        private PatternMatcher(Metadata<Filter> filter, String pattern) {
            try {
                this.pattern = Pattern.compile(pattern);
            }
            catch (PatternSyntaxException e) {
                throw new IllegalStateException("Error parsing pattern at " + filter, e);
            }
        }

        @Override
        public boolean matches(String input) {
            return this.pattern.matcher(input).matches();
        }
    }

    private static interface Matcher {
        public boolean matches(String var1);
    }
}

