/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.widgets;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.EventListener;
import org.jboss.errai.common.client.dom.KeyboardEvent;
import org.jboss.errai.common.client.dom.NumberInput;

@Dependent
public class SanitizedNumberInput
implements IsElement {
    @Inject
    NumberInput input;
    private boolean allowNegative = false;
    private boolean allowDecimal = false;

    public void init() {
        this.init("0", null, false, false);
    }

    public void init(String min, String step) {
        this.init(min, step, false, false);
    }

    public void init(String min, String step, boolean allowNegative, boolean allowDecimal) {
        if (min != null) {
            this.input.setAttribute("min", min);
        }
        if (step != null) {
            this.input.setAttribute("step", step);
        }
        this.allowDecimal = allowDecimal || step != null && step.contains(".");
        this.allowNegative = allowNegative || min != null && min.startsWith("-");
        this.input.addEventListener("keypress", this.getEventListener(this.allowNegative, this.allowDecimal), false);
    }

    protected EventListener<KeyboardEvent> getEventListener(boolean allowNegative, boolean allowDecimal) {
        return e -> {
            char k;
            String key = e.getKey();
            if (!(key.length() != 1 || (k = key.charAt(0)) == '-' && allowNegative || k == '.' && allowDecimal || k >= '0' && k <= '9')) {
                e.preventDefault();
            }
        };
    }

    public NumberInput getElement() {
        return this.input;
    }
}

