/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.file.exports;

import org.uberfire.ext.editor.commons.file.exports.PdfExportPreferences;
import org.uberfire.ext.editor.commons.file.exports.PdfFormatValidator;
import org.uberfire.ext.editor.commons.file.exports.PdfOrientationValidator;
import org.uberfire.ext.editor.commons.file.exports.PdfUnitValidator;
import org.uberfire.preferences.shared.annotations.Property;
import org.uberfire.preferences.shared.annotations.WorkbenchPreference;
import org.uberfire.preferences.shared.bean.BasePreference;
import org.uberfire.preferences.shared.impl.validation.EnumValuePropertyValidator;

@WorkbenchPreference(identifier="FileExport", bundleKey="FileExport.Label", parents={"LibraryPreferences"})
public class FileExportsPreferences
implements BasePreference<FileExportsPreferences> {
    @Property(bundleKey="FileExport.PdfOrientation.Text", helpBundleKey="FileExport.PdfOrientation.Help", validators={PdfOrientationValidator.class})
    String pdfOrientation;
    @Property(bundleKey="FileExport.PdfUnit.Text", helpBundleKey="FileExport.PdfUnit.Help", validators={PdfUnitValidator.class})
    String pdfUnit;
    @Property(bundleKey="FileExport.PdfFormat.Text", helpBundleKey="FileExport.PdfFormat.Help", validators={PdfFormatValidator.class})
    String pdfFormat;

    public FileExportsPreferences defaultValue(FileExportsPreferences defaultValue) {
        defaultValue.pdfOrientation = FileExportsPreferences.format(PdfExportPreferences.Orientation.PORTRAIT);
        defaultValue.pdfUnit = FileExportsPreferences.format(PdfExportPreferences.Unit.MM);
        defaultValue.pdfFormat = FileExportsPreferences.format(PdfExportPreferences.Format.A4);
        return defaultValue;
    }

    public PdfExportPreferences getPdfPreferences() {
        return PdfExportPreferences.create(this.pdfOrientation, this.pdfUnit, this.pdfFormat);
    }

    private static <T extends Enum<?>> String format(T value) {
        return EnumValuePropertyValidator.format(value);
    }
}

