/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.m2repo.backend.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.m2repo.backend.server.M2ServletContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixNotMavenizedArtifactInfo {
    private static final Logger logger = LoggerFactory.getLogger(FixNotMavenizedArtifactInfo.class);
    private static final Comparator<String> LONG_BEFORE_SHORT_COMPARATOR = Comparator.comparing(String::length).reversed().thenComparing(Comparator.naturalOrder());
    private final TreeMap<String, String[]> notMavenizedArtifacts = new TreeMap(LONG_BEFORE_SHORT_COMPARATOR);
    private static final String POM_TEMPLATE = "<project xmlns=\"http://maven.apache.org/POM/4.0.0\"\n         xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\n\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>{groupId}</groupId>\n  <artifactId>{artifactId}</artifactId>\n  <version>{version}</version>\n  <packaging>jar</packaging>\n</project>";

    public FixNotMavenizedArtifactInfo() {
        Properties notMavenizedArtifactsProps = new Properties();
        try {
            InputStream isNotMavenizedArtifacts = M2ServletContextListener.class.getResourceAsStream("/not-mavenized-artifacts.properties");
            if (isNotMavenizedArtifacts != null) {
                notMavenizedArtifactsProps.load(isNotMavenizedArtifacts);
            }
            for (Map.Entry<Object, Object> entry : notMavenizedArtifactsProps.entrySet()) {
                this.notMavenizedArtifacts.put(entry.getKey().toString() + "-", entry.getValue().toString().split(":"));
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public Properties getProperties(String filePath) {
        Properties result = new Properties();
        String fullFileName = filePath.substring(filePath.lastIndexOf(47) + 1);
        for (Map.Entry<String, String[]> entry : this.notMavenizedArtifacts.entrySet()) {
            if (!fullFileName.startsWith(entry.getKey())) continue;
            String fileVersion = fullFileName.substring(entry.getKey().length()).replace(".jar", "");
            result.put("groupId", entry.getValue()[0]);
            result.put("artifactId", entry.getValue()[1]);
            result.put("version", fileVersion);
            break;
        }
        return result;
    }

    public String buildPom(GAV gav) {
        return POM_TEMPLATE.replace("{groupId}", gav.getGroupId()).replace("{artifactId}", gav.getArtifactId()).replace("{version}", gav.getVersion());
    }
}

