/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth.pubkey;

import java.security.Key;
import java.security.PublicKey;
import java.util.Objects;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.client.auth.pubkey.PublicKeyIdentity;
import org.apache.sshd.common.config.keys.KeyUtils;

public class KeyAgentIdentity
implements PublicKeyIdentity {
    private final SshAgent agent;
    private final PublicKey key;
    private final String comment;

    public KeyAgentIdentity(SshAgent agent, PublicKey key, String comment) {
        this.agent = Objects.requireNonNull(agent, "No signing agent");
        this.key = Objects.requireNonNull(key, "No public key");
        this.comment = comment;
    }

    public PublicKey getPublicKey() {
        return this.key;
    }

    public String getComment() {
        return this.comment;
    }

    public byte[] sign(byte[] data) throws Exception {
        return this.agent.sign(this.getPublicKey(), data);
    }

    public String toString() {
        PublicKey pubKey = this.getPublicKey();
        return this.getClass().getSimpleName() + "[" + KeyUtils.getKeyType((Key)pubKey) + "] fingerprint=" + KeyUtils.getFingerPrint((PublicKey)pubKey) + ", comment=" + this.getComment();
    }
}

