/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.tom;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jgroups.Address;
import org.jgroups.Header;
import org.jgroups.protocols.tom.MessageID;
import org.jgroups.util.Bits;
import org.jgroups.util.Util;

public class ToaHeader
extends Header {
    public static final byte DATA_MESSAGE = 1;
    public static final byte PROPOSE_MESSAGE = 2;
    public static final byte FINAL_MESSAGE = 4;
    public static final byte SINGLE_DESTINATION_MESSAGE = 8;
    private byte type = 0;
    private MessageID messageID;
    private long sequencerNumber;
    private Collection<Address> destinations;

    public ToaHeader() {
    }

    private ToaHeader(MessageID messageID, byte type) {
        this.messageID = messageID;
        this.type = type;
    }

    public MessageID getMessageID() {
        return this.messageID;
    }

    private ToaHeader setDestinations(Collection<Address> addresses) {
        this.destinations = addresses;
        return this;
    }

    public Collection<Address> getDestinations() {
        return Collections.unmodifiableCollection(this.destinations);
    }

    public long getSequencerNumber() {
        return this.sequencerNumber;
    }

    public ToaHeader setSequencerNumber(long sequencerNumber) {
        this.sequencerNumber = sequencerNumber;
        return this;
    }

    public byte getType() {
        return this.type;
    }

    @Override
    public int size() {
        return (int)((long)(1 + this.messageID.serializedSize() + Bits.size(this.sequencerNumber)) + Util.size(this.destinations));
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        out.writeByte(this.type);
        this.messageID.writeTo(out);
        Bits.writeLong(this.sequencerNumber, out);
        if (this.type == 1) {
            Util.writeAddresses(this.destinations, out);
        }
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        this.type = in.readByte();
        this.messageID = new MessageID();
        this.messageID.readFrom(in);
        this.sequencerNumber = Bits.readLong(in);
        if (this.type == 1) {
            this.destinations = Util.readAddresses(in, ArrayList.class);
        }
    }

    @Override
    public String toString() {
        return "ToaHeader{type=" + ToaHeader.type2String(this.type) + ", message_id=" + this.messageID + ", sequence_number=" + this.sequencerNumber + ", destinations=" + this.destinations + '}';
    }

    public static String type2String(byte type) {
        switch (type) {
            case 1: {
                return "DATA_MESSAGE";
            }
            case 2: {
                return "PROPOSE_MESSAGE";
            }
            case 4: {
                return "FINAL_MESSAGE";
            }
            case 8: {
                return "SINGLE_DESTINATION_MESSAGE";
            }
        }
        return "UNKNOWN";
    }

    public static ToaHeader newDataMessageHeader(MessageID messageID, Collection<Address> destinations) {
        ToaHeader.assertMessageIDNotNull(messageID);
        return new ToaHeader(messageID, 1).setDestinations(new ArrayList<Address>(destinations));
    }

    public static ToaHeader newProposeMessageHeader(MessageID messageID, long sequencerNumber) {
        ToaHeader.assertMessageIDNotNull(messageID);
        return new ToaHeader(messageID, 2).setSequencerNumber(sequencerNumber);
    }

    public static ToaHeader newFinalMessageHeader(MessageID messageID, long sequenceNumber) {
        ToaHeader.assertMessageIDNotNull(messageID);
        return new ToaHeader(messageID, 4).setSequencerNumber(sequenceNumber);
    }

    public static ToaHeader createSingleDestinationHeader(MessageID messageID) {
        return new ToaHeader(messageID, 8);
    }

    private static void assertMessageIDNotNull(MessageID messageID) {
        if (messageID == null) {
            throw new NullPointerException("The message ID can't be null.");
        }
    }
}

