/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.allowlist;

import java.util.Collection;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.services.backend.allowlist.PackageNameAllowListFilter;
import org.kie.workbench.common.services.backend.allowlist.PackageNameAllowListLoader;
import org.kie.workbench.common.services.backend.allowlist.PackageNameAllowListSaver;
import org.kie.workbench.common.services.shared.allowlist.AllowList;
import org.kie.workbench.common.services.shared.allowlist.PackageNameAllowListService;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.OpenOption;

@Service
@ApplicationScoped
public class PackageNameAllowListServiceImpl
implements PackageNameAllowListService {
    private IOService ioService;
    private KieModuleService moduleService;
    private PackageNameAllowListLoader loader;
    private PackageNameAllowListSaver saver;

    public PackageNameAllowListServiceImpl() {
    }

    @Inject
    public PackageNameAllowListServiceImpl(@Named(value="ioStrategy") IOService ioService, KieModuleService moduleService, PackageNameAllowListLoader loader, PackageNameAllowListSaver saver) {
        this.ioService = ioService;
        this.moduleService = moduleService;
        this.loader = loader;
        this.saver = saver;
    }

    public void createModuleAllowList(Path packageNamesAllowListPath, String initialContent) {
        if (this.ioService.exists(Paths.convert((Path)packageNamesAllowListPath))) {
            throw new FileAlreadyExistsException(packageNamesAllowListPath.toString());
        }
        this.ioService.write(Paths.convert((Path)packageNamesAllowListPath), initialContent, new OpenOption[0]);
    }

    public AllowList filterPackageNames(Module module, Collection<String> packageNames) {
        if (packageNames == null) {
            return new AllowList();
        }
        if (module instanceof KieModule) {
            AllowList allowList = this.load(((KieModule)module).getPackageNamesAllowListPath());
            if (allowList.isEmpty()) {
                return new AllowList(packageNames);
            }
            for (Package aPackage : this.moduleService.resolvePackages(module)) {
                allowList.add(aPackage.getPackageName());
            }
            return new PackageNameAllowListFilter(packageNames, allowList).getFilteredPackageNames();
        }
        return new AllowList(packageNames);
    }

    public AllowList load(Path packageNamesAllowListPath) {
        return this.loader.load(packageNamesAllowListPath);
    }

    public Path save(Path path, AllowList content, Metadata metadata, String comment) {
        return this.saver.save(path, content, metadata, comment);
    }
}

