/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffConfig;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.FollowFilter;
import org.eclipse.jgit.revwalk.RenameCallback;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.TreeRevFilter;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.GitImpl;
import org.uberfire.java.nio.fs.jgit.util.model.CommitHistory;

public class ListCommits {
    private final Git git;
    private final ObjectId startRange;
    private final ObjectId endRange;
    private final String path;

    public ListCommits(Git git, Ref ref, String path) {
        this.git = git;
        this.path = ListCommits.makeRelative(path);
        this.startRange = null;
        this.endRange = ref.getObjectId();
    }

    private static String makeRelative(String path) {
        return path != null && path.startsWith("/") ? path.substring(1) : path;
    }

    public ListCommits(GitImpl git, ObjectId startRange, ObjectId endRange) {
        this.git = git;
        this.startRange = startRange;
        this.endRange = endRange;
        this.path = null;
    }

    public CommitHistory execute() throws IOException, GitAPIException {
        try (RevWalk rw = this.buildWalk();){
            if (this.path == null || this.path.isEmpty()) {
                CommitHistory commitHistory = this.fullCommitHistory(rw);
                return commitHistory;
            }
            CommitHistory commitHistory = this.pathCommitHistory(rw);
            return commitHistory;
        }
    }

    private CommitHistory pathCommitHistory(RevWalk rw) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        HashMap<AnyObjectId, String> pathByCommit = new HashMap<AnyObjectId, String>();
        ArrayList<RevCommit> commits = new ArrayList<RevCommit>();
        RenameCaptor renameCaptor = new RenameCaptor();
        TreeRevFilter revFilter = this.createTreeRevFilter(rw, this.path, renameCaptor);
        String curPath = this.path;
        for (RevCommit commit : rw) {
            if (!revFilter.include(rw, commit)) continue;
            TreeWalk tw = new TreeWalk(rw.getObjectReader());
            tw.setRecursive(true);
            tw.setFilter((TreeFilter)PathFilter.create((String)curPath));
            tw.addTree((AnyObjectId)commit.getTree());
            if (!tw.next()) continue;
            commits.add(commit);
            pathByCommit.put((AnyObjectId)commit.getId(), curPath);
            if (!renameCaptor.hasCaptured()) continue;
            curPath = renameCaptor.getAndReset().getOldPath();
        }
        return new CommitHistory(commits, pathByCommit, this.path);
    }

    private CommitHistory fullCommitHistory(RevWalk rw) {
        List<RevCommit> commits = StreamSupport.stream(rw.spliterator(), false).collect(Collectors.toList());
        return new CommitHistory(commits, Collections.emptyMap(), null);
    }

    private TreeRevFilter createTreeRevFilter(RevWalk rw, String curPath, RenameCallback renameCallback) {
        FollowFilter followFilter = FollowFilter.create((String)curPath, (DiffConfig)((DiffConfig)this.git.getRepository().getConfig().get(DiffConfig.KEY)));
        followFilter.setRenameCallback(renameCallback);
        TreeRevFilter revFilter = new TreeRevFilter(rw, (TreeFilter)followFilter);
        return revFilter;
    }

    private RevWalk buildWalk() throws GitAPIException, IOException {
        RevWalk rw = new RevWalk(this.git.getRepository());
        rw.setTreeFilter(TreeFilter.ANY_DIFF);
        rw.markStart(rw.parseCommit((AnyObjectId)this.endRange));
        rw.sort(RevSort.TOPO);
        if (this.startRange != null) {
            rw.markUninteresting(rw.parseCommit((AnyObjectId)this.startRange));
        }
        return rw;
    }

    private static class RenameCaptor
    extends RenameCallback {
        private DiffEntry captured;

        private RenameCaptor() {
        }

        public void renamed(DiffEntry entry) {
            this.captured = entry;
        }

        public boolean hasCaptured() {
            return this.captured != null;
        }

        public DiffEntry getAndReset() {
            if (this.captured == null) {
                throw new NullPointerException("Cannot get DiffEntry when none was captured.");
            }
            DiffEntry retVal = this.captured;
            this.captured = null;
            return retVal;
        }
    }
}

