/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.project;

import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.backend.server.ModuleResourcePathResolver;
import org.guvnor.common.services.project.backend.server.ResourceResolver;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.service.POMService;
import org.kie.workbench.common.services.shared.kmodule.KModuleService;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;

public class KieResourceResolver
extends ResourceResolver<KieModule> {
    private KModuleService kModuleService;

    public KieResourceResolver() {
    }

    @Inject
    public KieResourceResolver(@Named(value="ioStrategy") IOService ioService, POMService pomService, CommentedOptionFactory commentedOptionFactory, KModuleService kModuleService, Instance<ModuleResourcePathResolver> resourcePathResolversInstance) {
        super(ioService, pomService, commentedOptionFactory, resourcePathResolversInstance);
        this.kModuleService = kModuleService;
    }

    public KieModule resolveModule(org.uberfire.backend.vfs.Path resource, boolean loadPOM) {
        try {
            if (resource == null) {
                return null;
            }
            Path path = Paths.convert((org.uberfire.backend.vfs.Path)resource).normalize();
            if (Files.isRegularFile((Path)path, (LinkOption[])new LinkOption[0])) {
                path = path.getParent();
            }
            while (!this.hasPom(path)) {
                if ((path = path.getParent()) != null) continue;
                return null;
            }
            if (!this.hasKModule(path)) {
                return null;
            }
            if (loadPOM) {
                return this.makeModule(path);
            }
            return this.simpleModuleInstance(path);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    protected KieModule makeModule(Path nioModuleRootPath) {
        try {
            KieModule module = this.simpleModuleInstance(nioModuleRootPath);
            POM pom = (POM)this.pomService.load(module.getPomXMLPath());
            module.setPom(pom);
            return module;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Package resolvePackage(org.uberfire.backend.vfs.Path resource) {
        try {
            if (resource == null) {
                return null;
            }
            KieModule module = this.resolveModule(resource, false);
            if (module == null) {
                return null;
            }
            if (this.isPom(resource) || this.kModuleService.isKModule(resource)) {
                return null;
            }
            return this.makePackage((Module)module, resource);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public KieModule simpleModuleInstance(Path nioModuleRootPath) {
        org.uberfire.backend.vfs.Path moduleRootPath = Paths.convert((Path)nioModuleRootPath);
        org.uberfire.backend.vfs.Path pomXMLPath = Paths.convert((Path)nioModuleRootPath.resolve("pom.xml"));
        return new KieModule(moduleRootPath, pomXMLPath, Paths.convert((Path)nioModuleRootPath.resolve("src/main/resources/META-INF/kmodule.xml")), Paths.convert((Path)nioModuleRootPath.resolve("project.imports")), Paths.convert((Path)nioModuleRootPath.resolve("project.repositories")), Paths.convert((Path)nioModuleRootPath.resolve("package-names-allow-list")));
    }

    protected boolean hasKModule(Path path) {
        Path kmodulePath = path.resolve("src/main/resources/META-INF/kmodule.xml");
        return Files.exists((Path)kmodulePath, (LinkOption[])new LinkOption[0]);
    }
}

