/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.annotations.processors;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import org.uberfire.annotations.processors.AbstractErrorAbsorbingProcessor;
import org.uberfire.annotations.processors.ExperimentalActivityGenerator;
import org.uberfire.annotations.processors.ExperimentalFeatureDefinitionProviderGenerator;
import org.uberfire.annotations.processors.GenerationCompleteCallback;
import org.uberfire.annotations.processors.exceptions.GenerationException;
import org.uberfire.annotations.processors.facades.ClientAPIModule;

@SupportedAnnotationTypes(value={"org.uberfire.experimental.definition.annotations.ExperimentalFeature"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class ExperimentalFeatureProcessor
extends AbstractErrorAbsorbingProcessor {
    private static final String PROVIDER_SUFFIX = "ExperimentalFeatureDefinitionProvider";
    private static final String EXPERIMENTAL_ACTIVITY_SUFFIX = "ExperimentalFeatureActivityReference";
    private static final String PERSPECTIVE = "PERSPECTIVE";
    private static final String SCREEN = "SCREEN";
    private static final String EDITOR = "EDITOR";
    public static final Map<String, String> ACTIVITY_TYPES_MAPPING = new HashMap<String, String>();
    private ExperimentalFeatureDefinitionProviderGenerator providerGenerator;
    private ExperimentalActivityGenerator experimentalActivityGenerator;
    private GenerationCompleteCallback callback = null;

    public ExperimentalFeatureProcessor() {
        ExperimentalFeatureDefinitionProviderGenerator providerGen = null;
        ExperimentalActivityGenerator activityGen = null;
        try {
            providerGen = new ExperimentalFeatureDefinitionProviderGenerator();
            activityGen = new ExperimentalActivityGenerator();
        }
        catch (Throwable t) {
            this.rememberInitializationError(t);
        }
        this.providerGenerator = providerGen;
        this.experimentalActivityGenerator = activityGen;
    }

    ExperimentalFeatureProcessor(GenerationCompleteCallback callback) {
        this();
        this.callback = callback;
        System.out.println("GenerationCompleteCallback has been provided. Generated source code will not be compiled and hence classes will not be available.");
    }

    @Override
    protected boolean processWithExceptions(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws Exception {
        if (roundEnv.processingOver()) {
            return false;
        }
        if (roundEnv.errorRaised()) {
            return false;
        }
        Messager messager = this.processingEnv.getMessager();
        Elements elementUtils = this.processingEnv.getElementUtils();
        for (Element element : roundEnv.getElementsAnnotatedWith(elementUtils.getTypeElement("org.uberfire.experimental.definition.annotations.ExperimentalFeature"))) {
            if (element.getKind() != ElementKind.CLASS) continue;
            TypeElement classElement = (TypeElement)element;
            PackageElement packageElement = (PackageElement)classElement.getEnclosingElement();
            messager.printMessage(Diagnostic.Kind.NOTE, "Discovered experimental feature [" + classElement.getSimpleName() + "]");
            String packageName = packageElement.getQualifiedName().toString();
            String className = classElement.getSimpleName() + PROVIDER_SUFFIX;
            try {
                messager.printMessage(Diagnostic.Kind.NOTE, "Generating code for [" + className + "]");
                StringBuffer code = this.providerGenerator.generate(packageName, packageElement, className, classElement, this.processingEnv);
                this.write(packageName, className, code);
                if (!ExperimentalFeatureProcessor.getActivityType(classElement).isPresent()) continue;
                String activityClassName = classElement.getSimpleName() + EXPERIMENTAL_ACTIVITY_SUFFIX;
                StringBuffer activityCode = this.experimentalActivityGenerator.generate(packageName, packageElement, activityClassName, classElement, this.processingEnv);
                this.write(packageName, activityClassName, activityCode);
            }
            catch (GenerationException ge) {
                String msg = ge.getMessage();
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, classElement);
            }
        }
        return true;
    }

    public static Optional<String> getActivityType(TypeElement classElement) {
        return classElement.getAnnotationMirrors().stream().map(mirror -> ACTIVITY_TYPES_MAPPING.get(mirror.getAnnotationType().toString())).filter(Objects::nonNull).findAny();
    }

    private void write(String packageName, String className, StringBuffer code) throws IOException {
        if (this.callback == null) {
            this.writeCode(packageName, className, code);
        } else {
            this.callback.generationComplete(code.toString());
        }
    }

    static {
        ACTIVITY_TYPES_MAPPING.put(ClientAPIModule.getWorkbenchPerspectiveClass(), PERSPECTIVE);
        ACTIVITY_TYPES_MAPPING.put(ClientAPIModule.getWorkbenchScreenClass(), SCREEN);
        ACTIVITY_TYPES_MAPPING.put(ClientAPIModule.getWorkbenchEditorClass(), EDITOR);
    }
}

