/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.widgets;

import java.util.List;
import java.util.stream.Stream;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.Button;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Document;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;

@Templated(stylesheet="InlineNotification.css")
@Dependent
public class InlineNotification
implements IsElement {
    @Inject
    @DataField(value="alert")
    private Div alert;
    @Inject
    @DataField(value="message")
    private Span message;
    @Inject
    @DataField(value="icon")
    private Span icon;
    @Inject
    @DataField(value="dismiss")
    private Button dismiss;
    @Inject
    private Document document;

    public HTMLElement getElement() {
        return this.alert;
    }

    public void setMessage(String message) {
        this.message.setTextContent(message);
    }

    public void setMessage(List<String> messages) {
        DOMUtil.removeAllElementChildren((Node)this.message);
        HTMLElement ul = this.document.createElement("ul");
        DOMUtil.addCSSClass((HTMLElement)ul, (String)"list-unstyled");
        for (String message : messages) {
            HTMLElement li = this.document.createElement("li");
            li.setTextContent(message);
            ul.appendChild((Node)li);
        }
        this.message.appendChild((Node)ul);
    }

    public void setDismissable() {
        DOMUtil.addCSSClass((HTMLElement)this.alert, (String)"alert-dismissable");
        DOMUtil.removeCSSClass((HTMLElement)this.dismiss, (String)"hidden");
    }

    public void setType(InlineNotificationType type) {
        Stream.of(InlineNotificationType.values()).forEach(availableType -> {
            DOMUtil.removeCSSClass((HTMLElement)this.alert, (String)availableType.getCssClass());
            DOMUtil.removeCSSClass((HTMLElement)this.icon, (String)availableType.getIcon());
        });
        DOMUtil.addCSSClass((HTMLElement)this.alert, (String)type.getCssClass());
        DOMUtil.addCSSClass((HTMLElement)this.icon, (String)type.getIcon());
    }

    public static enum InlineNotificationType {
        SUCCESS("alert-success", "pficon-ok"),
        INFO("alert-info", "pficon-info"),
        WARNING("alert-warning", "pficon-warning-triangle-o"),
        DANGER("alert-danger", "pficon-error-circle-o");

        private String cssClass;
        private String icon;

        private InlineNotificationType(String cssClass, String icon) {
            this.cssClass = cssClass;
            this.icon = icon;
        }

        public String getCssClass() {
            return this.cssClass;
        }

        public String getIcon() {
            return this.icon;
        }
    }
}

