/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

@Deprecated
public enum MemoryUnit {
    BYTES("B"){

        @Override
        public long convert(long sourceSize, MemoryUnit sourceUnit) {
            return sourceUnit.toBytes(sourceSize);
        }

        @Override
        public long toBytes(long size) {
            return size;
        }

        @Override
        public long toKiloBytes(long size) {
            return size / 1000L;
        }

        @Override
        public long toKibiBytes(long size) {
            return size / 1024L;
        }

        @Override
        public long toMegaBytes(long size) {
            return size / 1000000L;
        }

        @Override
        public long toMebiBytes(long size) {
            return size / 0x100000L;
        }

        @Override
        public long toGigaBytes(long size) {
            return size / 1000000000L;
        }

        @Override
        public long toGibiBytes(long size) {
            return size / 0x40000000L;
        }

        @Override
        public long toTeraBytes(long size) {
            return size / 1000000000000L;
        }

        @Override
        public long toTebiBytes(long size) {
            return size / 0x10000000000L;
        }
    }
    ,
    KILOBYTES("K"){

        @Override
        public long convert(long sourceSize, MemoryUnit sourceUnit) {
            return sourceUnit.toKiloBytes(sourceSize);
        }

        @Override
        public long toBytes(long size) {
            return 2.x(size, 1000L, 9223372036854775L);
        }

        @Override
        public long toKiloBytes(long size) {
            return size;
        }

        @Override
        public long toKibiBytes(long size) {
            return 2.f(size, 1000L, 1024L);
        }

        @Override
        public long toMegaBytes(long size) {
            return size / 1000L;
        }

        @Override
        public long toMebiBytes(long size) {
            return 2.f(size, 1000L, 0x100000L);
        }

        @Override
        public long toGigaBytes(long size) {
            return size / 1000000L;
        }

        @Override
        public long toGibiBytes(long size) {
            return 2.f(size, 1000L, 0x40000000L);
        }

        @Override
        public long toTeraBytes(long size) {
            return size / 1000000000L;
        }

        @Override
        public long toTebiBytes(long size) {
            return 2.f(size, 1000L, 0x10000000000L);
        }
    }
    ,
    KIBIBYTES("Ki"){

        @Override
        public long convert(long sourceSize, MemoryUnit sourceUnit) {
            return sourceUnit.toKibiBytes(sourceSize);
        }

        @Override
        public long toBytes(long size) {
            return 3.x(size, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toKiloBytes(long size) {
            return 3.f(size, 1024L, 1000L);
        }

        @Override
        public long toKibiBytes(long size) {
            return size;
        }

        @Override
        public long toMegaBytes(long size) {
            return 3.f(size, 1024L, 1000000L);
        }

        @Override
        public long toMebiBytes(long size) {
            return size / 1024L;
        }

        @Override
        public long toGigaBytes(long size) {
            return 3.f(size, 1024L, 1000000000L);
        }

        @Override
        public long toGibiBytes(long size) {
            return size / 0x100000L;
        }

        @Override
        public long toTeraBytes(long size) {
            return 3.f(size, 1024L, 1000000000000L);
        }

        @Override
        public long toTebiBytes(long size) {
            return size / 0x40000000L;
        }
    }
    ,
    MEGABYTES("M"){

        @Override
        public long convert(long sourceSize, MemoryUnit sourceUnit) {
            return sourceUnit.toMegaBytes(sourceSize);
        }

        @Override
        public long toBytes(long size) {
            return 4.x(size, 1000000L, 9223372036854L);
        }

        @Override
        public long toKiloBytes(long size) {
            return 4.x(size, 1000L, 9223372036854775L);
        }

        @Override
        public long toKibiBytes(long size) {
            return 4.f(size, 1000000L, 1024L);
        }

        @Override
        public long toMegaBytes(long size) {
            return size;
        }

        @Override
        public long toMebiBytes(long size) {
            return 4.f(size, 1000000L, 0x100000L);
        }

        @Override
        public long toGigaBytes(long size) {
            return size / 1000L;
        }

        @Override
        public long toGibiBytes(long size) {
            return 4.f(size, 1000000L, 0x40000000L);
        }

        @Override
        public long toTeraBytes(long size) {
            return size / 1000000L;
        }

        @Override
        public long toTebiBytes(long size) {
            return 4.f(size, 1000000L, 0x10000000000L);
        }
    }
    ,
    MEBIBYTES("Mi"){

        @Override
        public long convert(long sourceSize, MemoryUnit sourceUnit) {
            return sourceUnit.toMebiBytes(sourceSize);
        }

        @Override
        public long toBytes(long size) {
            return 5.x(size, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toKiloBytes(long size) {
            return 5.f(size, 0x100000L, 1000L);
        }

        @Override
        public long toKibiBytes(long size) {
            return 5.x(size, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toMegaBytes(long size) {
            return 5.f(size, 0x100000L, 1000000L);
        }

        @Override
        public long toMebiBytes(long size) {
            return size;
        }

        @Override
        public long toGigaBytes(long size) {
            return 5.f(size, 0x100000L, 1000000000L);
        }

        @Override
        public long toGibiBytes(long size) {
            return size / 1024L;
        }

        @Override
        public long toTeraBytes(long size) {
            return 5.f(size, 0x100000L, 1000000000000L);
        }

        @Override
        public long toTebiBytes(long size) {
            return size / 0x100000L;
        }
    }
    ,
    GIGABYTES("G"){

        @Override
        public long convert(long sourceSize, MemoryUnit sourceUnit) {
            return sourceUnit.toGigaBytes(sourceSize);
        }

        @Override
        public long toBytes(long size) {
            return 6.x(size, 1000000000L, 9223372036L);
        }

        @Override
        public long toKiloBytes(long size) {
            return 6.x(size, 1000000L, 9223372036854L);
        }

        @Override
        public long toKibiBytes(long size) {
            return 6.f(size, 1000000000L, 1024L);
        }

        @Override
        public long toMegaBytes(long size) {
            return 6.x(size, 1000L, 9223372036854775L);
        }

        @Override
        public long toMebiBytes(long size) {
            return 6.f(size, 1000000000L, 0x100000L);
        }

        @Override
        public long toGigaBytes(long size) {
            return size;
        }

        @Override
        public long toGibiBytes(long size) {
            return 6.f(size, 1000000000L, 0x40000000L);
        }

        @Override
        public long toTeraBytes(long size) {
            return size / 1000L;
        }

        @Override
        public long toTebiBytes(long size) {
            return 6.f(size, 1000000000L, 0x10000000000L);
        }
    }
    ,
    GIBIBYTES("Gi"){

        @Override
        public long convert(long sourceSize, MemoryUnit sourceUnit) {
            return sourceUnit.toGibiBytes(sourceSize);
        }

        @Override
        public long toBytes(long size) {
            return 7.x(size, 0x40000000L, 0x1FFFFFFFFL);
        }

        @Override
        public long toKiloBytes(long size) {
            return 7.f(size, 0x40000000L, 1000L);
        }

        @Override
        public long toKibiBytes(long size) {
            return 7.x(size, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toMegaBytes(long size) {
            return 7.f(size, 0x40000000L, 1000000L);
        }

        @Override
        public long toMebiBytes(long size) {
            return 7.x(size, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toGigaBytes(long size) {
            return 7.f(size, 0x40000000L, 1000000000L);
        }

        @Override
        public long toGibiBytes(long size) {
            return size;
        }

        @Override
        public long toTeraBytes(long size) {
            return 7.f(size, 0x40000000L, 1000000000000L);
        }

        @Override
        public long toTebiBytes(long size) {
            return size / 1024L;
        }
    }
    ,
    TERABYTES("T"){

        @Override
        public long convert(long sourceSize, MemoryUnit sourceUnit) {
            return sourceUnit.toTeraBytes(sourceSize);
        }

        @Override
        public long toBytes(long size) {
            return 8.x(size, 1000000000000L, 0x8CBCCCL);
        }

        @Override
        public long toKiloBytes(long size) {
            return 8.x(size, 1000000000L, 9223372036L);
        }

        @Override
        public long toKibiBytes(long size) {
            return 8.f(size, 1000000000000L, 1024L);
        }

        @Override
        public long toMegaBytes(long size) {
            return 8.x(size, 1000000L, 9223372036854L);
        }

        @Override
        public long toMebiBytes(long size) {
            return 8.f(size, 1000000000000L, 0x100000L);
        }

        @Override
        public long toGigaBytes(long size) {
            return 8.x(size, 1000L, 9223372036854775L);
        }

        @Override
        public long toGibiBytes(long size) {
            return 8.f(size, 1000000000000L, 0x40000000L);
        }

        @Override
        public long toTeraBytes(long size) {
            return size;
        }

        @Override
        public long toTebiBytes(long size) {
            return 8.f(size, 1000000000000L, 0x10000000000L);
        }
    }
    ,
    TEBIBYTES("Ti"){

        @Override
        public long convert(long sourceSize, MemoryUnit sourceUnit) {
            return sourceUnit.toTebiBytes(sourceSize);
        }

        @Override
        public long toBytes(long size) {
            return 9.x(size, 0x10000000000L, 0x7FFFFFL);
        }

        @Override
        public long toKiloBytes(long size) {
            return 9.f(size, 0x10000000000L, 1000L);
        }

        @Override
        public long toKibiBytes(long size) {
            return 9.x(size, 0x40000000L, 0x1FFFFFFFFL);
        }

        @Override
        public long toMegaBytes(long size) {
            return 9.f(size, 0x10000000000L, 1000000L);
        }

        @Override
        public long toMebiBytes(long size) {
            return 9.x(size, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toGigaBytes(long size) {
            return 9.f(size, 0x10000000000L, 1000000000L);
        }

        @Override
        public long toGibiBytes(long size) {
            return 9.x(size, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toTeraBytes(long size) {
            return 9.f(size, 0x10000000000L, 1000000000000L);
        }

        @Override
        public long toTebiBytes(long size) {
            return size;
        }
    };

    private static final long KILO = 1000L;
    private static final long KIBI = 1024L;
    private static final long MEGA = 1000000L;
    private static final long MEBI = 0x100000L;
    private static final long GIGA = 1000000000L;
    private static final long GIBI = 0x40000000L;
    private static final long TERA = 1000000000000L;
    private static final long TEBI = 0x10000000000L;
    static final long MAX = Long.MAX_VALUE;
    private final String suffix;

    private MemoryUnit(String suffix) {
        this.suffix = suffix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    static long f(long d, long numerator, long denominator) {
        return (long)((float)d * (float)numerator / (float)denominator);
    }

    static long x(long d, long m, long over) {
        if (d > over) {
            return Long.MAX_VALUE;
        }
        if (d < -over) {
            return Long.MIN_VALUE;
        }
        return d * m;
    }

    public long convert(long sourceSize, MemoryUnit sourceUnit) {
        throw new AbstractMethodError();
    }

    public long toBytes(long size) {
        throw new AbstractMethodError();
    }

    public long toKiloBytes(long size) {
        throw new AbstractMethodError();
    }

    public long toKibiBytes(long size) {
        throw new AbstractMethodError();
    }

    public long toMegaBytes(long size) {
        throw new AbstractMethodError();
    }

    public long toMebiBytes(long size) {
        throw new AbstractMethodError();
    }

    public long toGigaBytes(long size) {
        throw new AbstractMethodError();
    }

    public long toGibiBytes(long size) {
        throw new AbstractMethodError();
    }

    public long toTeraBytes(long size) {
        throw new AbstractMethodError();
    }

    public long toTebiBytes(long size) {
        throw new AbstractMethodError();
    }

    public static long parseBytes(String s) {
        int us;
        if (s == null) {
            throw new NullPointerException();
        }
        for (us = s.length(); us > 0 && !Character.isDigit(s.charAt(us - 1)); --us) {
        }
        if (us == s.length()) {
            return Long.parseLong(s);
        }
        String suffix = s.substring(us);
        for (MemoryUnit u : MemoryUnit.values()) {
            if (!u.suffix.equals(suffix)) continue;
            long size = Long.parseLong(s.substring(0, us));
            return u.toBytes(size);
        }
        throw new IllegalArgumentException(s);
    }
}

