/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.type.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.client.workbench.type.ClientTypeRegistry;

@ApplicationScoped
public class ClientTypeRegistryImpl
implements ClientTypeRegistry {
    private final SyncBeanManager iocManager;
    private List<ClientResourceType> localResourceTypes = new ArrayList<ClientResourceType>();

    @Inject
    public ClientTypeRegistryImpl(SyncBeanManager iocManager) {
        this.iocManager = iocManager;
    }

    @PostConstruct
    public void init() {
        Collection availableTypes = this.iocManager.lookupBeans(ClientResourceType.class);
        for (SyncBeanDef availableType : availableTypes) {
            this.localResourceTypes.add((ClientResourceType)availableType.getInstance());
        }
        Collections.sort(this.localResourceTypes, new Comparator<ClientResourceType>(){

            @Override
            public int compare(ClientResourceType o1, ClientResourceType o2) {
                if (o1.getPriority() < o2.getPriority()) {
                    return 1;
                }
                if (o1.getPriority() > o2.getPriority()) {
                    return -1;
                }
                return 0;
            }
        });
    }

    @Override
    public Collection<ClientResourceType> getRegisteredTypes() {
        return Collections.unmodifiableList(this.localResourceTypes);
    }

    @Override
    public ClientResourceType resolve(Path path) {
        for (ClientResourceType resourceType : this.localResourceTypes) {
            if (!resourceType.accept(path)) continue;
            return resourceType;
        }
        return null;
    }

    @Override
    public String resolveWildcardPattern(String shortName) {
        for (ClientResourceType resourceType : this.localResourceTypes) {
            if (!resourceType.getShortName().equalsIgnoreCase(shortName)) continue;
            return resourceType.getSimpleWildcardPattern();
        }
        return shortName;
    }
}

