/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command;

import org.drools.core.command.impl.ExecutableCommand;
import org.drools.core.command.impl.RegistryContext;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.RuleUnitExecutor;

public class NewRuleUnitExecutorCommand
implements ExecutableCommand<RuleUnitExecutor> {
    private static final long serialVersionUID = 8955950765481938826L;
    private String sessionId;
    private ReleaseId releaseId;

    public NewRuleUnitExecutorCommand(String sessionId) {
        this.sessionId = sessionId;
    }

    public NewRuleUnitExecutorCommand(ReleaseId releaseId, String sessionId) {
        this.sessionId = sessionId;
        this.releaseId = releaseId;
    }

    @Override
    public RuleUnitExecutor execute(Context context) {
        KieContainer kieContainer;
        if (this.releaseId != null) {
            KieServices kieServices = KieServices.Factory.get();
            kieContainer = kieServices.newKieContainer(this.releaseId);
        } else {
            kieContainer = ((RegistryContext)context).lookup(KieContainer.class);
            if (kieContainer == null) {
                throw new RuntimeException("ReleaseId was not specfied, nor was an existing KieContainer assigned to the Registry");
            }
        }
        RuleUnitExecutor ruleUnitExecutor = this.sessionId != null ? kieContainer.newRuleUnitExecutor(this.sessionId) : kieContainer.newRuleUnitExecutor();
        ((RegistryContext)context).register(RuleUnitExecutor.class, ruleUnitExecutor);
        ((RegistryContext)context).register(KieSession.class, ruleUnitExecutor.getKieSession());
        return ruleUnitExecutor;
    }

    public String toString() {
        return "NewRuleUnitExecutorCommand{sessionId='" + this.sessionId + '\'' + ", releaseId=" + this.releaseId + '}';
    }
}

