/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.ast;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.ast.ASTNode;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.lang.ast.ContextEntryNode;
import org.kie.dmn.feel.lang.ast.ListNode;
import org.kie.dmn.feel.lang.impl.MapBackedType;
import org.kie.dmn.feel.runtime.functions.CustomFEELFunction;
import org.kie.dmn.feel.runtime.functions.DTInvokerFunction;
import org.kie.dmn.feel.runtime.functions.JavaFunction;
import org.kie.dmn.feel.util.EvalHelper;

public class ContextNode
extends BaseNode {
    private List<ContextEntryNode> entries = new ArrayList<ContextEntryNode>();
    private MapBackedType parsedResultType = new MapBackedType();

    public ContextNode(ParserRuleContext ctx) {
        super(ctx);
    }

    public ContextNode(ParserRuleContext ctx, ListNode list) {
        super(ctx);
        for (BaseNode node : list.getElements()) {
            ContextEntryNode entry = (ContextEntryNode)node;
            this.entries.add(entry);
            this.parsedResultType.addField(entry.getName().getText(), entry.getResultType());
        }
    }

    public List<ContextEntryNode> getEntries() {
        return this.entries;
    }

    public void setEntries(List<ContextEntryNode> entries) {
        this.entries = entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object evaluate(EvaluationContext ctx) {
        try {
            ctx.enterFrame();
            LinkedHashMap<String, Object> c = new LinkedHashMap<String, Object>();
            for (ContextEntryNode cen : this.entries) {
                String name = EvalHelper.normalizeVariableName(cen.evaluateName(ctx));
                Object value = cen.evaluate(ctx);
                if (value instanceof CustomFEELFunction) {
                    ((CustomFEELFunction)value).setName(name);
                } else if (value instanceof JavaFunction) {
                    ((JavaFunction)value).setName(name);
                } else if (value instanceof DTInvokerFunction) {
                    ((DTInvokerFunction)value).setName(name);
                }
                ctx.setValue(name, value);
                c.put(name, value);
            }
            LinkedHashMap<String, Object> linkedHashMap = c;
            return linkedHashMap;
        }
        finally {
            ctx.exitFrame();
        }
    }

    @Override
    public Type getResultType() {
        return this.parsedResultType;
    }

    @Override
    public ASTNode[] getChildrenNode() {
        return this.entries.toArray(new ASTNode[this.entries.size()]);
    }
}

