/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.ast;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.ast.ASTNode;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.lang.ast.ListNode;
import org.kie.dmn.feel.lang.ast.NameRefNode;
import org.kie.dmn.feel.lang.ast.QualifiedNameNode;
import org.kie.dmn.feel.runtime.FEELFunction;
import org.kie.dmn.feel.runtime.UnaryTest;
import org.kie.dmn.feel.util.Msg;

public class FunctionInvocationNode
extends BaseNode {
    private BaseNode name;
    private ListNode params;

    public FunctionInvocationNode(ParserRuleContext ctx, BaseNode name, ListNode params) {
        super(ctx);
        this.name = name;
        this.params = params;
    }

    public BaseNode getName() {
        return this.name;
    }

    public void setName(BaseNode name) {
        this.name = name;
    }

    public ListNode getParams() {
        return this.params;
    }

    public void setParams(ListNode params) {
        this.params = params;
    }

    @Override
    public Object evaluate(EvaluationContext ctx) {
        Object[] p;
        FEELFunction function = null;
        Object value = null;
        if (this.name instanceof NameRefNode) {
            value = ctx.getValue(this.name.getText());
        } else {
            QualifiedNameNode qn = (QualifiedNameNode)this.name;
            String[] qns = qn.getPartsAsStringArray();
            value = ctx.getValue(qns);
        }
        if (value instanceof FEELFunction) {
            function = (FEELFunction)value;
            if (function != null) {
                p = this.params.getElements().stream().map(e -> e.evaluate(ctx)).toArray(Object[]::new);
                List<String> functionNameParts = this.name instanceof NameRefNode ? Arrays.asList(this.name.getText()) : Arrays.asList(((QualifiedNameNode)this.name).getPartsAsStringArray());
                Object result = this.invokeTheFunction(functionNameParts, function, ctx, p);
                return result;
            }
            ctx.notifyEvt(this.astEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.FUNCTION_NOT_FOUND, this.name.getText())));
        } else if (value instanceof UnaryTest) {
            if (this.params.getElements().size() == 1) {
                p = this.params.getElements().get(0).evaluate(ctx);
                return ((UnaryTest)value).apply(ctx, p);
            }
            ctx.notifyEvt(this.astEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.CAN_T_INVOKE_AN_UNARY_TEST_WITH_S_PARAMETERS_UNARY_TESTS_REQUIRE_1_SINGLE_PARAMETER, this.params.getElements().size())));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeTheFunction(List<String> names, FEELFunction fn, EvaluationContext ctx, Object[] params) {
        if (names.size() == 1) {
            Object result = fn.invokeReflectively(ctx, params);
            return result;
        }
        try {
            Object newRoot = ctx.getValue(names.get(0));
            ctx.enterFrame();
            try {
                Map asMap = (Map)newRoot;
                asMap.forEach(ctx::setValue);
            }
            catch (ClassCastException e) {
                ctx.setRootObject(newRoot);
            }
            Object object = this.invokeTheFunction(names.subList(1, names.size()), fn, ctx, params);
            return object;
        }
        finally {
            ctx.exitFrame();
        }
    }

    @Override
    public Type getResultType() {
        return this.name.getResultType();
    }

    @Override
    public ASTNode[] getChildrenNode() {
        return new ASTNode[]{this.name, this.params};
    }
}

