/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.ast;

import java.util.Collection;
import java.util.List;
import java.util.function.BiPredicate;
import org.antlr.v4.runtime.ParserRuleContext;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.ast.ASTNode;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.feel.runtime.UnaryTest;
import org.kie.dmn.feel.runtime.UnaryTestImpl;
import org.kie.dmn.feel.util.EvalHelper;
import org.kie.dmn.feel.util.Msg;

public class UnaryTestNode
extends BaseNode {
    private UnaryOperator operator;
    private BaseNode value;

    public UnaryTestNode(String op, BaseNode value) {
        this.setText(op + " " + value.getText());
        this.operator = UnaryOperator.determineOperator(op);
        this.value = value;
    }

    public UnaryTestNode(UnaryOperator op, BaseNode value) {
        this.setText(op.symbol + " " + value.getText());
        this.operator = op;
        this.value = value;
    }

    public UnaryTestNode(ParserRuleContext ctx, String op, BaseNode value) {
        super(ctx);
        this.operator = UnaryOperator.determineOperator(op);
        this.value = value;
    }

    public UnaryOperator getOperator() {
        return this.operator;
    }

    public void setOperator(UnaryOperator operator) {
        this.operator = operator;
    }

    public BaseNode getValue() {
        return this.value;
    }

    public void setValue(BaseNode value) {
        this.value = value;
    }

    @Override
    public UnaryTest evaluate(EvaluationContext ctx) {
        switch (this.operator) {
            case LTE: {
                return new UnaryTestImpl(this.createCompareUnaryTest((l, r) -> l.compareTo(r) <= 0), this.value.getText());
            }
            case LT: {
                return new UnaryTestImpl(this.createCompareUnaryTest((l, r) -> l.compareTo(r) < 0), this.value.getText());
            }
            case GT: {
                return new UnaryTestImpl(this.createCompareUnaryTest((l, r) -> l.compareTo(r) > 0), this.value.getText());
            }
            case GTE: {
                return new UnaryTestImpl(this.createCompareUnaryTest((l, r) -> l.compareTo(r) >= 0), this.value.getText());
            }
            case EQ: {
                return new UnaryTestImpl(this.createIsEqualUnaryTest(), this.value.getText());
            }
            case NE: {
                return new UnaryTestImpl(this.createIsNotEqualUnaryTest(), this.value.getText());
            }
            case IN: {
                return new UnaryTestImpl(this.createInUnaryTest(), this.value.getText());
            }
            case NOT: {
                return new UnaryTestImpl(this.createNotUnaryTest(), this.value.getText());
            }
            case TEST: {
                return new UnaryTestImpl(this.createBooleanUnaryTest(), this.value.getText());
            }
        }
        ctx.notifyEvt(this.astEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.NULL_OR_UNKNOWN_OPERATOR)));
        return null;
    }

    private UnaryTest createCompareUnaryTest(BiPredicate<Comparable, Comparable> op) {
        return (context, left) -> {
            Object right = this.value.evaluate((EvaluationContext)context);
            return EvalHelper.compare(left, right, context, op);
        };
    }

    private Boolean utEqualSemantic(Object left, Object right, EvaluationContext context) {
        if (right instanceof Collection) {
            return ((Collection)right).contains(left);
        }
        return EvalHelper.isEqual(left, right, context);
    }

    private UnaryTest createIsEqualUnaryTest() {
        return (context, left) -> {
            Object right = this.value.evaluate((EvaluationContext)context);
            return this.utEqualSemantic(left, right, (EvaluationContext)context);
        };
    }

    private UnaryTest createIsNotEqualUnaryTest() {
        return (context, left) -> {
            Object right = this.value.evaluate((EvaluationContext)context);
            Boolean result = this.utEqualSemantic(left, right, (EvaluationContext)context);
            return result != null ? Boolean.valueOf(result == false) : null;
        };
    }

    private UnaryTest createInUnaryTest() {
        return (c, o) -> {
            if (o == null) {
                return false;
            }
            Object val = this.value.evaluate((EvaluationContext)c);
            if (val instanceof Range) {
                try {
                    return ((Range)val).includes(o);
                }
                catch (Exception e) {
                    c.notifyEvt(this.astEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.EXPRESSION_IS_RANGE_BUT_VALUE_IS_NOT_COMPARABLE, o.toString(), val.toString())));
                    throw e;
                }
            }
            if (val instanceof Collection) {
                return ((Collection)val).contains(o);
            }
            return false;
        };
    }

    private UnaryTest createNotUnaryTest() {
        return (c, o) -> {
            Object val = this.value.evaluate((EvaluationContext)c);
            if (val == null) {
                return null;
            }
            List tests = (List)val;
            for (Object test : tests) {
                if (test == null) {
                    if (o != null) continue;
                    return false;
                }
                if (test instanceof UnaryTest) {
                    if (!((Boolean)((UnaryTest)test).apply(c, o)).booleanValue()) continue;
                    return false;
                }
                if (o == null) {
                    if (test != null) continue;
                    return false;
                }
                if (test instanceof Range) {
                    try {
                        if (!((Range)test).includes(o).booleanValue()) continue;
                        return false;
                    }
                    catch (Exception e) {
                        c.notifyEvt(this.astEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.EXPRESSION_IS_RANGE_BUT_VALUE_IS_NOT_COMPARABLE, o.toString(), test.toString())));
                        throw e;
                    }
                }
                if (test instanceof Collection) {
                    return !((Collection)test).contains(o);
                }
                if (!test.equals(o)) continue;
                return false;
            }
            return true;
        };
    }

    private UnaryTest createBooleanUnaryTest() {
        return (context, left) -> {
            Object right = this.value.evaluate((EvaluationContext)context);
            if (right instanceof Boolean) {
                return (Boolean)right;
            }
            context.notifyEvt(this.astEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.EXTENDED_UNARY_TEST_MUST_BE_BOOLEAN, left.toString(), this.value.toString())));
            return Boolean.FALSE;
        };
    }

    @Override
    public ASTNode[] getChildrenNode() {
        return new ASTNode[]{this.value};
    }

    public static enum UnaryOperator {
        LTE("<="),
        LT("<"),
        GT(">"),
        GTE(">="),
        NE("!="),
        EQ("="),
        NOT("not"),
        IN("in"),
        TEST("test");

        public final String symbol;

        private UnaryOperator(String symbol) {
            this.symbol = symbol;
        }

        public static UnaryOperator determineOperator(String symbol) {
            for (UnaryOperator op : UnaryOperator.values()) {
                if (!op.symbol.equals(symbol)) continue;
                return op;
            }
            throw new IllegalArgumentException("No operator found for symbol '" + symbol + "'");
        }
    }
}

