/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.types;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.lang.SimpleType;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.types.BuiltInTypeSymbol;
import org.kie.dmn.feel.marshaller.FEELStringMarshaller;
import org.kie.dmn.feel.runtime.FEELFunction;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.feel.runtime.UnaryTest;

public enum BuiltInType implements SimpleType
{
    UNKNOWN("any", "unknown"),
    NUMBER("number"),
    STRING("string"),
    DATE("date"),
    TIME("time"),
    DATE_TIME("date and time", "dateTime"),
    DURATION("duration", "days and time duration", "years and months duration", "dayTimeDuration", "yearMonthDuration"),
    BOOLEAN("boolean"),
    RANGE("range"),
    FUNCTION("function"),
    LIST("list"),
    CONTEXT("context"),
    UNARY_TEST("unary test");

    private final String[] names;
    private final Collection<BuiltInTypeSymbol> symbols;

    private BuiltInType(String ... names) {
        this.names = names;
        this.symbols = Arrays.asList(names).stream().map(n -> new BuiltInTypeSymbol((String)n, this)).collect(Collectors.toList());
    }

    @Override
    public String getName() {
        return this.names[0];
    }

    public String[] getNames() {
        return this.names;
    }

    public Object fromString(String value) {
        return FEELStringMarshaller.INSTANCE.unmarshall((Type)this, value);
    }

    public String toString(Object value) {
        return FEELStringMarshaller.INSTANCE.marshall(value);
    }

    public static <T> Function<FEELEvent, T> justNull() {
        return t -> null;
    }

    public Collection<BuiltInTypeSymbol> getSymbols() {
        return this.symbols;
    }

    public String toString() {
        return "Type{ " + this.names[0] + " }";
    }

    public static Type determineTypeFromName(String name) {
        if (name == null) {
            return UNKNOWN;
        }
        for (BuiltInType t : BuiltInType.values()) {
            for (String n : t.getNames()) {
                if (!n.equals(name)) continue;
                return t;
            }
        }
        return UNKNOWN;
    }

    public static Type determineTypeFromInstance(Object o) {
        if (o == null) {
            return UNKNOWN;
        }
        if (o instanceof Number) {
            return NUMBER;
        }
        if (o instanceof String) {
            return STRING;
        }
        if (o instanceof LocalDate) {
            return DATE;
        }
        if (o instanceof LocalTime || o instanceof OffsetTime) {
            return TIME;
        }
        if (o instanceof ZonedDateTime || o instanceof OffsetDateTime || o instanceof LocalDateTime) {
            return DATE_TIME;
        }
        if (o instanceof Duration || o instanceof Period) {
            return DURATION;
        }
        if (o instanceof Boolean) {
            return BOOLEAN;
        }
        if (o instanceof UnaryTest) {
            return UNARY_TEST;
        }
        if (o instanceof Range) {
            return RANGE;
        }
        if (o instanceof FEELFunction) {
            return FUNCTION;
        }
        if (o instanceof List) {
            return LIST;
        }
        if (o instanceof Map) {
            return CONTEXT;
        }
        return UNKNOWN;
    }

    public static boolean isInstanceOf(Object o, Type t) {
        if (o == null) {
            return false;
        }
        if (t == UNKNOWN) {
            return true;
        }
        return BuiltInType.determineTypeFromInstance(o) == t;
    }

    public static boolean isInstanceOf(Object o, String name) {
        return BuiltInType.determineTypeFromInstance(o) == BuiltInType.determineTypeFromName(name);
    }

    @Override
    public boolean isInstanceOf(Object o) {
        return BuiltInType.isInstanceOf(o, this);
    }

    @Override
    public boolean isAssignableValue(Object value) {
        if (value == null) {
            return true;
        }
        return BuiltInType.isInstanceOf(value, this);
    }
}

