/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.ws;

import java.net.URI;
import org.eclipse.jgit.diff.DiffEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.base.WatchContext;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.Paths;
import org.uberfire.java.nio.file.StandardWatchEventKind;
import org.uberfire.java.nio.file.WatchEvent;

public class JGitWatchEvent
implements WatchEvent {
    private static final Logger LOGGER = LoggerFactory.getLogger(JGitWatchEvent.class);
    private final URI oldPath;
    private final URI newPath;
    private final String sessionId;
    private final String userName;
    private final String message;
    private final String changeType;

    public JGitWatchEvent(String sessionId, String userName, String message, String changeType, Path oldPath, Path newPath) {
        this.sessionId = sessionId;
        this.userName = userName;
        this.message = message;
        this.changeType = changeType;
        this.oldPath = oldPath != null ? oldPath.toUri() : null;
        this.newPath = newPath != null ? newPath.toUri() : null;
    }

    public WatchEvent.Kind kind() {
        DiffEntry.ChangeType changeType = DiffEntry.ChangeType.valueOf((String)this.changeType);
        switch (changeType) {
            case ADD: 
            case COPY: {
                return StandardWatchEventKind.ENTRY_CREATE;
            }
            case DELETE: {
                return StandardWatchEventKind.ENTRY_DELETE;
            }
            case MODIFY: {
                return StandardWatchEventKind.ENTRY_MODIFY;
            }
            case RENAME: {
                return StandardWatchEventKind.ENTRY_RENAME;
            }
        }
        throw new RuntimeException("Unsupported change type: " + changeType);
    }

    public int count() {
        return 1;
    }

    public Object context() {
        return new WatchContext(){

            public Path getPath() {
                return JGitWatchEvent.this.newPath != null ? this.lookup(JGitWatchEvent.this.newPath) : null;
            }

            public Path getOldPath() {
                return JGitWatchEvent.this.oldPath != null ? this.lookup(JGitWatchEvent.this.oldPath) : null;
            }

            private Path lookup(URI uri) {
                Path path = null;
                try {
                    path = Paths.get((URI)uri);
                }
                catch (Exception e) {
                    LOGGER.error("Error trying to translate to path uri: " + uri);
                }
                return path;
            }

            public String getSessionId() {
                return JGitWatchEvent.this.sessionId;
            }

            public String getMessage() {
                return JGitWatchEvent.this.message;
            }

            public String getUser() {
                return JGitWatchEvent.this.userName;
            }
        };
    }

    public String toString() {
        return "WatchEvent{newPath=" + this.newPath + ", oldPath=" + this.oldPath + ", sessionId='" + this.sessionId + '\'' + ", userName='" + this.userName + '\'' + ", message='" + this.message + '\'' + ", changeType=" + this.changeType + '}';
    }
}

