/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.compiler.impl;

import java.io.File;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.RebaseResult;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.kie.workbench.common.services.backend.compiler.nio.decorators.JGITCompilerBeforeDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;

public class JGitUtils {
    private static final Logger logger = LoggerFactory.getLogger(JGITCompilerBeforeDecorator.class);
    private static String REMOTE = "origin";
    private static String TEMP = System.getProperty("java.io.tmpdir") + File.separatorChar + "maven/";

    public static Boolean applyBefore(Git git) {
        Boolean result = Boolean.FALSE;
        try {
            PullCommand pc = git.pull().setRemote(REMOTE).setRebase(Boolean.TRUE.booleanValue());
            PullResult pullRes = pc.call();
            RebaseResult rr = pullRes.getRebaseResult();
            if (rr.getStatus().equals((Object)RebaseResult.Status.UP_TO_DATE) || rr.getStatus().equals((Object)RebaseResult.Status.FAST_FORWARD)) {
                result = Boolean.TRUE;
            }
            if (rr.getStatus().equals((Object)RebaseResult.Status.UNCOMMITTED_CHANGES)) {
                PullResult pr = git.pull().call();
                result = pr.isSuccessful() ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return result;
    }

    public static Git tempClone(JGitFileSystem fs, String uuid) {
        try {
            return Git.cloneRepository().setURI(fs.getGit().getRepository().getDirectory().toURI().toString()).setDirectory(new File(TEMP + uuid, fs.getGit().getRepository().getDirectory().getName().replaceFirst("\\.git", ""))).setBare(false).setCloneAllBranches(true).call();
        }
        catch (GitAPIException e) {
            throw new RuntimeException(e);
        }
    }
}

