/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.lucene.index.directory;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.SearcherFactory;
import org.kie.soup.commons.validation.Preconditions;
import org.uberfire.ext.metadata.backend.lucene.index.BaseLuceneIndex;
import org.uberfire.ext.metadata.backend.lucene.index.directory.Directory;
import org.uberfire.ext.metadata.model.KCluster;

public class DirectoryLuceneIndex
extends BaseLuceneIndex {
    private final KCluster cluster;
    private final IndexWriter writer;
    private final Directory directory;
    private AtomicBoolean freshIndex;
    private AtomicBoolean isDisposed = new AtomicBoolean(false);

    public DirectoryLuceneIndex(KCluster cluster, Directory directory, IndexWriterConfig config) {
        try {
            this.cluster = (KCluster)Preconditions.checkNotNull((String)"cluster", (Object)cluster);
            this.directory = (Directory)Preconditions.checkNotNull((String)"directory", (Object)directory);
            this.writer = new IndexWriter(directory.getDirectory(), config);
            this.freshIndex = new AtomicBoolean(directory.freshIndex());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public IndexWriter writer() {
        return this.writer;
    }

    public KCluster getCluster() {
        return this.cluster;
    }

    @Override
    public IndexReader nrtReader() {
        try {
            return DirectoryReader.open((IndexWriter)this.writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void nrtRelease(IndexReader reader) {
        try {
            reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IndexSearcher nrtSearcher() {
        try {
            return new SearcherFactory().newSearcher(this.nrtReader(), null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void nrtRelease(IndexSearcher searcher) {
        try {
            searcher.getIndexReader().close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void dispose() {
        if (this.isDisposed.get()) {
            return;
        }
        this.closeWriter();
        this.directory.close();
        this.isDisposed.set(true);
    }

    private void closeWriter() {
        try {
            this.writer.commit();
            this.writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean freshIndex() {
        return this.freshIndex.get();
    }

    public void commit() {
        try {
            this.writer.commit();
            this.freshIndex.set(false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void delete() {
        this.closeWriter();
        this.directory.delete();
        this.isDisposed.set(true);
    }
}

