/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import javax.xml.namespace.QName;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.api.core.event.DMNRuntimeEventManager;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.core.api.DMNExpressionEvaluator;
import org.kie.dmn.core.api.EvaluatorResult;
import org.kie.dmn.core.ast.EvaluatorResultImpl;
import org.kie.dmn.core.impl.DMNModelImpl;
import org.kie.dmn.core.impl.DMNResultImpl;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.core.util.MsgUtil;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.impl.EvaluationContextImpl;
import org.kie.dmn.feel.lang.impl.FEELEventListenersManager;
import org.kie.dmn.feel.lang.impl.FEELImpl;
import org.kie.dmn.feel.lang.impl.NamedParameter;
import org.kie.dmn.feel.lang.impl.RootExecutionFrame;
import org.kie.dmn.feel.runtime.FEELFunction;
import org.kie.dmn.model.v1_1.DMNElement;
import org.kie.dmn.model.v1_1.DMNModelInstrumentedBase;
import org.kie.dmn.model.v1_1.Invocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNInvocationEvaluator
implements DMNExpressionEvaluator {
    private static final Logger logger = LoggerFactory.getLogger(DMNInvocationEvaluator.class);
    private final Invocation invocation;
    private final String nodeName;
    private final DMNElement node;
    private final String functionName;
    private final List<ActualParameter> parameters = new ArrayList<ActualParameter>();
    private final BiFunction<DMNContext, String, FEELFunction> functionLocator;
    private final FEEL feel;

    public DMNInvocationEvaluator(String nodeName, DMNElement node, String functionName, Invocation invocation, BiFunction<DMNContext, String, FEELFunction> functionLocator, FEEL feel) {
        this.nodeName = nodeName;
        this.node = node;
        this.functionName = functionName;
        this.invocation = invocation;
        this.functionLocator = functionLocator == null ? (ctx, fname) -> (FEELFunction)ctx.get(fname) : functionLocator;
        this.feel = feel;
    }

    public void addParameter(String name, DMNType type, DMNExpressionEvaluator evaluator) {
        this.parameters.add(new ActualParameter(name, type, evaluator));
    }

    public List<ActualParameter> getParameters() {
        return this.parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EvaluatorResult evaluate(DMNRuntimeEventManager eventManager, DMNResult dmnr) {
        ArrayList<FEELEvent> events = new ArrayList<FEELEvent>();
        DMNResultImpl result = (DMNResultImpl)dmnr;
        DMNContext previousContext = result.getContext();
        DMNContext dmnContext = previousContext.clone();
        result.setContext(dmnContext);
        Object invocationResult = null;
        boolean walkedIntoScope = false;
        String[] fnameParts = this.functionName.split("\\.");
        if (fnameParts.length > 1) {
            QName importAlias = ((DMNModelImpl)((DMNResultImpl)dmnr).getModel()).getImportAliasesForNS().get(fnameParts[0]);
            dmnContext.pushScope(fnameParts[0], importAlias.getNamespaceURI());
            walkedIntoScope = true;
        }
        try {
            boolean hasErrors;
            Object r;
            FEELFunction function = this.functionLocator.apply(dmnContext, fnameParts.length > 1 ? fnameParts[1] : this.functionName);
            if (function == null) {
                r = null;
                r = this.feel != null ? ((FEELImpl)this.feel).newEvaluationContext(Collections.emptyList(), Collections.emptyMap()).getValue(this.functionName) : RootExecutionFrame.INSTANCE.getValue(this.functionName);
                if (r != null && r instanceof FEELFunction) {
                    function = (FEELFunction)r;
                }
            }
            if (function == null) {
                MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)this.node, result, null, null, Msg.FUNCTION_NOT_FOUND, this.functionName, this.nodeName);
                r = new EvaluatorResultImpl(null, EvaluatorResult.ResultType.FAILURE);
                return r;
            }
            Object[] namedParams = new Object[this.parameters.size()];
            int index = 0;
            for (ActualParameter param : this.parameters) {
                try {
                    EvaluatorResult value = param.expression.evaluate(eventManager, result);
                    if (value.getResultType() != EvaluatorResult.ResultType.SUCCESS) {
                        MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)this.node, result, null, null, Msg.ERR_EVAL_PARAM_FOR_INVOCATION_ON_NODE, param.name, this.functionName, this.nodeName);
                        EvaluatorResultImpl evaluatorResultImpl = new EvaluatorResultImpl(null, EvaluatorResult.ResultType.FAILURE);
                        return evaluatorResultImpl;
                    }
                    namedParams[index++] = new NamedParameter(param.name, value.getResult());
                }
                catch (Exception e) {
                    MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)this.node, result, e, null, Msg.ERR_INVOKING_PARAM_EXPR_FOR_PARAM_ON_NODE, param.name, this.nodeName);
                    EvaluatorResultImpl evaluatorResultImpl = new EvaluatorResultImpl(null, EvaluatorResult.ResultType.FAILURE);
                    return evaluatorResultImpl;
                }
            }
            FEELEventListenersManager listenerMgr = new FEELEventListenersManager();
            listenerMgr.addListener(events::add);
            EvaluationContextImpl ctx = new EvaluationContextImpl(listenerMgr, eventManager.getRuntime());
            invocationResult = function.invokeReflectively((EvaluationContext)ctx, namedParams);
            if (walkedIntoScope) {
                dmnContext.popScope();
            }
            EvaluatorResultImpl evaluatorResultImpl = new EvaluatorResultImpl(invocationResult, (hasErrors = this.hasErrors(events, eventManager, result)) ? EvaluatorResult.ResultType.FAILURE : EvaluatorResult.ResultType.SUCCESS);
            return evaluatorResultImpl;
        }
        catch (Throwable t) {
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)this.node, result, t, null, Msg.ERR_INVOKING_FUNCTION_ON_NODE, this.functionName, this.nodeName);
            EvaluatorResultImpl evaluatorResultImpl = new EvaluatorResultImpl(null, EvaluatorResult.ResultType.FAILURE);
            return evaluatorResultImpl;
        }
        finally {
            result.setContext(previousContext);
        }
    }

    private boolean hasErrors(List<FEELEvent> events, DMNRuntimeEventManager eventManager, DMNResultImpl result) {
        boolean hasErrors = false;
        for (FEELEvent e : events) {
            if (e.getSeverity() != FEELEvent.Severity.ERROR) continue;
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)this.invocation, result, null, e, Msg.FEEL_ERROR, e.getMessage());
            hasErrors = true;
        }
        events.clear();
        return hasErrors;
    }

    private static class ActualParameter {
        final String name;
        final DMNType type;
        final DMNExpressionEvaluator expression;

        public ActualParameter(String name, DMNType type, DMNExpressionEvaluator evaluator) {
            this.name = name;
            this.type = type;
            this.expression = evaluator;
        }
    }
}

