/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.system.configuration;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.structure.backend.config.ConfigGroupMarshaller;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigType;
import org.jboss.errai.security.shared.api.identity.User;
import org.kie.workbench.common.migration.cli.SystemAccess;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.workbench.type.FileNameUtil;

@ApplicationScoped
public class ConfigGroupsMigrationService {
    private Repository systemRepository;
    private ConfigGroupMarshaller marshaller;
    private IOService ioService;
    private FileSystem fs;
    private SystemAccess system;
    private User identity;

    public ConfigGroupsMigrationService() {
    }

    @Inject
    public ConfigGroupsMigrationService(@Named(value="system") Repository systemRepository, ConfigGroupMarshaller marshaller, @Named(value="configIO") IOService ioService, @Named(value="systemFS") FileSystem fs, SystemAccess system, User identity) {
        this.systemRepository = systemRepository;
        this.marshaller = marshaller;
        this.ioService = ioService;
        this.fs = fs;
        this.system = system;
        this.identity = identity;
    }

    public void groupSystemConfigGroups() {
        try {
            this.startBatch();
            this.system.out().println("Moving existing configurations to their type directories...");
            this.groupConfigGroupsByType();
            this.system.out().println("Moving existing repositories configurations to their space directories...");
            this.groupRepositoryConfigGroupsBySpace();
        }
        finally {
            this.endBatch();
        }
    }

    private void startBatch() {
        this.ioService.startBatch(this.ioService.get(this.systemRepository.getUri(), new String[0]).getFileSystem());
    }

    private void endBatch() {
        this.ioService.endBatch();
    }

    private void groupConfigGroupsByType() {
        Path systemDir = this.ioService.get(this.systemRepository.getUri(), new String[0]);
        for (ConfigType oldType : ConfigType.values()) {
            String oldExt = oldType.getExt();
            DirectoryStream<Path> foundConfigs = this.getDirectoryStreamForFilesWithParticularExtension(systemDir, oldExt);
            ConfigType newType = this.getNewType(oldType);
            Path newTypeDir = systemDir.resolve(newType.getDir());
            if (!this.ioService.exists(newTypeDir)) {
                this.ioService.createDirectory(newTypeDir, new FileAttribute[0]);
            }
            for (Path oldPath : foundConfigs) {
                String newExt = newType.getExt();
                String oldFileName = Paths.convert((Path)oldPath).getFileName();
                String newFileName = FileNameUtil.removeExtension((String)oldFileName, (String)oldExt.substring(1)) + newExt;
                Path newPath = newTypeDir.resolve(newFileName);
                this.ioService.move(oldPath, newPath, new CopyOption[0]);
                if (newType.equals((Object)oldType)) continue;
                String content = this.ioService.readAllString(newPath);
                ConfigGroup configGroup = this.marshaller.unmarshall(content);
                configGroup.setType(newType);
                this.ioService.write(newPath, this.marshaller.marshall(configGroup), new OpenOption[]{new CommentedOption(this.getIdentityName(), "Updated configuration type.")});
            }
        }
    }

    private ConfigType getNewType(ConfigType oldType) {
        if (ConfigType.ORGANIZATIONAL_UNIT.equals((Object)oldType)) {
            return ConfigType.SPACE;
        }
        return oldType;
    }

    private DirectoryStream<Path> getDirectoryStreamForFilesWithParticularExtension(Path dir, String extension) {
        return this.ioService.newDirectoryStream(dir, entry -> !Files.isDirectory((Path)entry, (LinkOption[])new LinkOption[0]) && !entry.getFileName().toString().startsWith(".") && entry.getFileName().toString().endsWith(extension));
    }

    private void groupRepositoryConfigGroupsBySpace() {
        Path systemDir = this.ioService.get(this.systemRepository.getUri(), new String[0]);
        Path repositoriesDir = systemDir.resolve(ConfigType.REPOSITORY.getDir());
        DirectoryStream<Path> repoConfigs = this.getDirectoryStreamForFilesWithParticularExtension(repositoriesDir, ConfigType.REPOSITORY.getExt());
        for (Path oldPath : repoConfigs) {
            String fileName = Paths.convert((Path)oldPath).getFileName();
            String content = this.ioService.readAllString(oldPath);
            ConfigGroup repoConfig = this.marshaller.unmarshall(content);
            String space = repoConfig.getConfigItemValue("space");
            Path newPath = repositoriesDir.resolve(space).resolve(fileName);
            this.ioService.move(oldPath, newPath, new CopyOption[0]);
        }
    }

    protected String getIdentityName() {
        try {
            return this.identity.getIdentifier();
        }
        catch (Exception e) {
            return "unknown";
        }
    }
}

