/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.system.configuration;

import java.lang.annotation.Annotation;
import java.nio.file.Path;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;
import org.kie.workbench.common.migration.cli.MigrationTool;
import org.kie.workbench.common.migration.cli.SystemAccess;
import org.kie.workbench.common.migration.cli.ToolConfig;
import org.kie.workbench.common.project.cli.MigrationSetup;
import org.kie.workbench.common.project.cli.PromptService;
import org.kie.workbench.common.system.configuration.ConfigGroupsMigrationService;

public class SystemConfigurationMigrationTool
implements MigrationTool {
    public static final String NAME = "System configuration directory structure migration";
    private SystemAccess system;
    private ToolConfig config;

    public String getTitle() {
        return NAME;
    }

    public String getDescription() {
        return "Moves old system configuration directory structure to the new one";
    }

    public Integer getPriority() {
        return 1;
    }

    public void run(ToolConfig config, SystemAccess system) {
        this.config = config;
        this.system = system;
        PromptService promptService = new PromptService(system, config);
        system.out().println("Starting system configuration directory structure migration");
        if (this.validateTarget() && promptService.maybePromptForBackup()) {
            Path niogitDir = config.getTarget();
            MigrationSetup.configureProperties((SystemAccess)system, (Path)niogitDir);
            this.migrate();
        }
    }

    private void migrate() {
        WeldContainer container = null;
        try {
            container = new Weld().initialize();
            ConfigGroupsMigrationService configGroupsMigrationService = SystemConfigurationMigrationTool.loadMigrationService(container);
            configGroupsMigrationService.groupSystemConfigGroups();
        }
        catch (Throwable t) {
            this.system.err().println("Error during migration: ");
            t.printStackTrace(this.system.err());
        }
        finally {
            if (container != null && container.isRunning()) {
                this.quietShutdown(container);
            }
        }
    }

    private void quietShutdown(WeldContainer container) {
        try {
            container.shutdown();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean validateTarget() {
        if (!this.config.getTarget().resolve("system").resolve("system.git").toFile().exists()) {
            this.system.err().println(String.format("The PROJECT STRUCTURE MIGRATION must be ran before this one.", new Object[0]));
            return false;
        }
        return true;
    }

    private static ConfigGroupsMigrationService loadMigrationService(WeldContainer container) {
        return (ConfigGroupsMigrationService)container.instance().select(ConfigGroupsMigrationService.class, new Annotation[0]).get();
    }
}

