/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.system.configuration;

import java.io.IOException;
import java.util.List;
import javax.enterprise.event.Event;
import org.guvnor.structure.backend.config.ConfigGroupMarshaller;
import org.guvnor.structure.backend.config.ConfigurationServiceImpl;
import org.guvnor.structure.backend.config.DefaultPasswordServiceImpl;
import org.guvnor.structure.config.SystemRepositoryChangedEvent;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationFactory;
import org.guvnor.structure.server.config.ConfigurationService;
import org.guvnor.structure.server.config.PasswordService;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.migration.cli.RealSystemAccess;
import org.kie.workbench.common.migration.cli.SystemAccess;
import org.kie.workbench.common.project.config.MigrationConfigurationFactoryImpl;
import org.kie.workbench.common.project.config.MigrationConfigurationServiceImpl;
import org.kie.workbench.common.system.configuration.ConfigGroupsMigrationService;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.mocks.FileSystemTestingUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class ConfigGroupsMigrationServiceTest {
    private static FileSystemTestingUtils fileSystemTestingUtils = new FileSystemTestingUtils();
    @Mock
    private Repository systemRepository;
    @Mock
    private Event<SystemRepositoryChangedEvent> repoChangedEvent;
    @Mock
    private Event<SystemRepositoryChangedEvent> spaceChangedEvent;
    @Mock
    private Event<SystemRepositoryChangedEvent> changedEvent;
    @Mock
    private User identity;
    @InjectMocks
    private RealSystemAccess system;
    private ConfigGroupMarshaller marshaller;
    private IOService ioService;
    private ConfigurationFactory oldConfigurationFactory;
    private ConfigurationService oldConfigurationService;
    private ConfigurationService newConfigurationService;
    private ConfigGroupsMigrationService configGroupsMigrationService;

    @Before
    public void setup() throws IOException {
        fileSystemTestingUtils.setup();
        Mockito.when((Object)this.systemRepository.getUri()).thenReturn((Object)"git://amend-repo-test");
        this.marshaller = new ConfigGroupMarshaller();
        this.ioService = this.mockIoService();
        this.oldConfigurationFactory = new MigrationConfigurationFactoryImpl((PasswordService)new DefaultPasswordServiceImpl());
        this.oldConfigurationService = new MigrationConfigurationServiceImpl(this.systemRepository, this.marshaller, this.identity, this.ioService, this.repoChangedEvent, this.spaceChangedEvent, this.changedEvent, fileSystemTestingUtils.getFileSystem());
        this.newConfigurationService = new ConfigurationServiceImpl(this.systemRepository, this.marshaller, this.identity, this.ioService, this.repoChangedEvent, this.spaceChangedEvent, this.changedEvent, fileSystemTestingUtils.getFileSystem());
        this.configGroupsMigrationService = new ConfigGroupsMigrationService(this.systemRepository, this.marshaller, this.ioService, fileSystemTestingUtils.getFileSystem(), (SystemAccess)this.system, this.identity);
    }

    @After
    public void cleanupFileSystem() {
        fileSystemTestingUtils.cleanup();
    }

    @Test
    public void groupSystemConfigGroupsTest() {
        this.createConfigGroupsWithOldConfigurationService();
        this.migrateConfigGroups();
        this.checkConfigGroupsWithNewConfigurationService();
    }

    private void createConfigGroupsWithOldConfigurationService() {
        this.oldConfigurationService.addConfiguration(this.oldConfigurationFactory.newConfigGroup(ConfigType.GLOBAL, "global1", "global1-description"));
        this.oldConfigurationService.addConfiguration(this.oldConfigurationFactory.newConfigGroup(ConfigType.GLOBAL, "global2", "global2-description"));
        this.oldConfigurationService.addConfiguration(this.oldConfigurationFactory.newConfigGroup(ConfigType.ORGANIZATIONAL_UNIT, "ou1", "ou1-description"));
        this.oldConfigurationService.addConfiguration(this.oldConfigurationFactory.newConfigGroup(ConfigType.ORGANIZATIONAL_UNIT, "ou2", "ou2-description"));
        ConfigGroup repo1 = this.oldConfigurationFactory.newConfigGroup(ConfigType.REPOSITORY, "repo1", "repo1-description");
        repo1.addConfigItem(this.oldConfigurationFactory.newConfigItem("space", "ou1"));
        this.oldConfigurationService.addConfiguration(repo1);
        ConfigGroup repo2 = this.oldConfigurationFactory.newConfigGroup(ConfigType.REPOSITORY, "repo2", "repo2-description");
        repo2.addConfigItem(this.oldConfigurationFactory.newConfigItem("space", "ou1"));
        this.oldConfigurationService.addConfiguration(repo2);
        this.oldConfigurationService.addConfiguration(this.oldConfigurationFactory.newConfigGroup(ConfigType.EDITOR, "editor1", "editor1-description"));
        this.oldConfigurationService.addConfiguration(this.oldConfigurationFactory.newConfigGroup(ConfigType.EDITOR, "editor2", "editor2-description"));
        this.oldConfigurationService.addConfiguration(this.oldConfigurationFactory.newConfigGroup(ConfigType.DEPLOYMENT, "deployment1", "deployment1-description"));
        this.oldConfigurationService.addConfiguration(this.oldConfigurationFactory.newConfigGroup(ConfigType.DEPLOYMENT, "deployment2", "deployment2-description"));
    }

    private void migrateConfigGroups() {
        this.configGroupsMigrationService.groupSystemConfigGroups();
    }

    private void checkConfigGroupsWithNewConfigurationService() {
        this.checkConfigGroupsOfAType(ConfigType.GLOBAL, 2, "global1", "global2");
        this.checkConfigGroupsOfAType(ConfigType.ORGANIZATIONAL_UNIT, 0, new String[0]);
        this.checkConfigGroupsOfAType(ConfigType.SPACE, 2, "ou1", "ou2");
        this.checkConfigGroupsOfAType(ConfigType.REPOSITORY, "ou1", 2, "repo1", "repo2");
        this.checkConfigGroupsOfAType(ConfigType.REPOSITORY, "ou2", 0, new String[0]);
        this.checkConfigGroupsOfAType(ConfigType.EDITOR, 2, "editor1", "editor2");
        this.checkConfigGroupsOfAType(ConfigType.DEPLOYMENT, 2, "deployment1", "deployment2");
    }

    private void checkConfigGroupsOfAType(ConfigType configType, int size, String ... names) {
        List configGroups = this.newConfigurationService.getConfiguration(configType);
        this.checkConfigGroups(configGroups, size, names);
    }

    private void checkConfigGroupsOfAType(ConfigType configType, String namespace, int size, String ... names) {
        List configGroups = this.newConfigurationService.getConfiguration(configType, namespace);
        this.checkConfigGroups(configGroups, size, names);
    }

    private void checkConfigGroups(List<ConfigGroup> configGroups, int size, String ... names) {
        Assert.assertEquals((long)size, (long)configGroups.size());
        int i = 0;
        for (String name : names) {
            Assert.assertEquals((Object)name, (Object)configGroups.get(i++).getName());
        }
    }

    private IOService mockIoService() {
        IOService ioService = (IOService)Mockito.spy((Object)fileSystemTestingUtils.getIoService());
        ((IOService)Mockito.doNothing().when((Object)ioService)).startBatch((FileSystem)ArgumentMatchers.any(FileSystem.class));
        ((IOService)Mockito.doNothing().when((Object)ioService)).endBatch();
        return ioService;
    }
}

