/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.system.space.configuration;

import java.nio.file.Path;
import org.jboss.weld.environment.se.Weld;
import org.kie.workbench.common.migration.cli.ContainerHandler;
import org.kie.workbench.common.migration.cli.MigrationSetup;
import org.kie.workbench.common.migration.cli.MigrationTool;
import org.kie.workbench.common.migration.cli.SystemAccess;
import org.kie.workbench.common.migration.cli.ToolConfig;
import org.kie.workbench.common.project.cli.PromptService;
import org.kie.workbench.common.system.space.configuration.ConfigGroupsMigrationService;

public class SystemToSpaceConfigurationMigrationTool
implements MigrationTool {
    public static final String NAME = "System to space configuration repository migration";
    private SystemAccess system;
    private ToolConfig config;

    public String getTitle() {
        return NAME;
    }

    public String getDescription() {
        return "Moves spaces and repositories metadata to each space configuration repository";
    }

    public Integer getPriority() {
        return 4;
    }

    public boolean isSystemMigration() {
        return false;
    }

    public void run(ToolConfig config, SystemAccess system) {
        this.config = config;
        this.system = system;
        PromptService promptService = new PromptService(system, config);
        system.out().println("Starting system to space configuration repository migration");
        if (promptService.maybePromptForBackup()) {
            Path niogitDir = config.getTarget();
            MigrationSetup.configureProperties((SystemAccess)system, (Path)niogitDir);
            this.migrate();
        }
    }

    private void migrate() {
        ContainerHandler container = new ContainerHandler(() -> new Weld().initialize());
        container.run(ConfigGroupsMigrationService.class, ConfigGroupsMigrationService::moveDataToSpaceConfigRepo, error -> {
            this.system.err().println("Error during migration: ");
            error.printStackTrace(this.system.err());
        });
    }
}

