/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.system.space.configuration;

import java.io.File;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.guvnor.structure.backend.backcompat.BackwardCompatibleUtil;
import org.guvnor.structure.backend.config.ConfigurationServiceImpl;
import org.guvnor.structure.contributors.ContributorType;
import org.guvnor.structure.organizationalunit.config.RepositoryInfo;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorageRegistry;
import org.guvnor.structure.organizationalunit.config.SpaceInfo;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationService;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.migration.cli.MigrationSetup;
import org.kie.workbench.common.migration.cli.RealSystemAccess;
import org.kie.workbench.common.migration.cli.SystemAccess;
import org.kie.workbench.common.project.cli.util.ConfigGroupToSpaceInfoConverter;
import org.kie.workbench.common.system.space.configuration.ConfigGroupsMigrationService;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.spaces.SpacesAPI;

@RunWith(value=MockitoJUnitRunner.class)
public class ConfigGroupsMigrationServiceTest {
    private static final String SPACE_NAME = "MySpace";
    private static final String SPACE_GROUP = "com.myspace";
    private static final Boolean DELETED = Boolean.FALSE;
    private static final Integer CONTRIBUTORS = 1;
    private static final String CONTRIBUTOR = "admin";
    private static final Integer SPACE_REPOS = 2;
    private Boolean REPO_AVOID_INDEX = Boolean.FALSE;
    private static final String TEST_LEGACY_REPO = "testLegacy";
    private static final String TEST_MULTIPLE_INSTANCE_REPO = "test-multiple-instance";
    private static final File NIOGIT_DIR = Paths.get("target/.niogit", new String[0]).toFile();
    private SystemAccess system = new RealSystemAccess();
    private WeldContainer weldContainer;
    private ConfigurationServiceImpl configurationService;
    private SpaceConfigStorageRegistry spaceConfigStorageRegistry;
    private BackwardCompatibleUtil backwardCompatibleUtil;
    private ConfigGroupToSpaceInfoConverter configGroupToSpaceInfoConverter;
    private ConfigGroupsMigrationService migrationService;

    @Before
    public void init() {
        MigrationSetup.configureProperties((SystemAccess)this.system, (Path)NIOGIT_DIR.toPath());
        this.weldContainer = new Weld().initialize();
        this.configurationService = (ConfigurationServiceImpl)Mockito.spy((Object)this.weldContainer.instance().select(ConfigurationServiceImpl.class, new Annotation[0]).get());
        this.spaceConfigStorageRegistry = (SpaceConfigStorageRegistry)this.weldContainer.instance().select(SpaceConfigStorageRegistry.class, new Annotation[0]).get();
        this.backwardCompatibleUtil = (BackwardCompatibleUtil)Mockito.spy((Object)this.weldContainer.instance().select(BackwardCompatibleUtil.class, new Annotation[0]).get());
        this.configGroupToSpaceInfoConverter = (ConfigGroupToSpaceInfoConverter)Mockito.spy((Object)new ConfigGroupToSpaceInfoConverter((ConfigurationService)this.configurationService, this.backwardCompatibleUtil, this.spaceConfigStorageRegistry));
        this.migrationService = (ConfigGroupsMigrationService)Mockito.spy((Object)new ConfigGroupsMigrationService((ConfigurationService)this.configurationService, this.spaceConfigStorageRegistry, this.configGroupToSpaceInfoConverter));
    }

    @Test
    public void testMigration() {
        this.migrationService.moveDataToSpaceConfigRepo();
        ArgumentCaptor infoCaptor = ArgumentCaptor.forClass(SpaceInfo.class);
        ((ConfigurationServiceImpl)Mockito.verify((Object)this.configurationService)).getConfiguration((ConfigType)ArgumentMatchers.eq((Object)ConfigType.SPACE));
        ((ConfigurationServiceImpl)Mockito.verify((Object)this.configurationService, (VerificationMode)Mockito.times((int)2))).getConfiguration((ConfigType)ArgumentMatchers.eq((Object)ConfigType.REPOSITORY), (String)ArgumentMatchers.eq((Object)SPACE_NAME));
        ((ConfigGroupsMigrationService)Mockito.verify((Object)this.migrationService)).saveSpaceInfo((SpaceInfo)infoCaptor.capture());
        ((BackwardCompatibleUtil)Mockito.verify((Object)this.backwardCompatibleUtil, (VerificationMode)Mockito.times((int)5))).compat((ConfigGroup)ArgumentMatchers.any());
        ((ConfigurationServiceImpl)Mockito.verify((Object)this.configurationService)).removeConfiguration((ConfigGroup)ArgumentMatchers.any());
        ((ConfigGroupToSpaceInfoConverter)Mockito.verify((Object)this.configGroupToSpaceInfoConverter)).cleanUpRepositories((ConfigGroup)ArgumentMatchers.any());
        SpaceInfo info = (SpaceInfo)infoCaptor.getValue();
        ((ObjectAssert)Assertions.assertThat((Object)info).hasFieldOrPropertyWithValue("name", (Object)SPACE_NAME)).hasFieldOrPropertyWithValue("defaultGroupId", (Object)SPACE_GROUP);
        Assertions.assertThat((Iterable)info.getContributors()).hasSize(CONTRIBUTORS.intValue());
        ((ObjectAssert)Assertions.assertThat(info.getContributors().iterator().next()).hasFieldOrPropertyWithValue("username", (Object)CONTRIBUTOR)).hasFieldOrPropertyWithValue("type", (Object)ContributorType.OWNER);
        info.getRepositories().forEach(repositoryInfo -> Assertions.assertThat((Map)repositoryInfo.getConfiguration().getEnvironment()).doesNotContainKeys((Object[])new String[]{"username", "password", "secure:password"}));
        ((ConfigurationServiceImpl)Mockito.verify((Object)this.configurationService)).cleanUpSystemRepository();
        Assertions.assertThat((List)info.getSecurityGroups()).isEmpty();
        Assertions.assertThat((List)info.getRepositories()).hasSize(SPACE_REPOS.intValue());
        this.checkSpaceRepo(TEST_LEGACY_REPO, info);
        this.checkSpaceRepo(TEST_MULTIPLE_INSTANCE_REPO, info);
    }

    private void checkSpaceRepo(String repoName, SpaceInfo info) {
        RepositoryInfo spaceRepo = info.getRepositories().stream().filter(repo -> repo.getName().equals(repoName)).findAny().orElse(null);
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)spaceRepo).isNotNull()).hasFieldOrPropertyWithValue("name", (Object)repoName)).hasFieldOrPropertyWithValue("deleted", (Object)DELETED);
        Assert.assertEquals((Object)SPACE_NAME, (Object)spaceRepo.getSpace());
        Assert.assertEquals((Object)SpacesAPI.Scheme.GIT.toString(), (Object)spaceRepo.getScheme());
        Assert.assertEquals((Object)this.REPO_AVOID_INDEX, (Object)spaceRepo.isAvoidIndex());
        Assertions.assertThat((List)spaceRepo.getContributors()).hasSize(CONTRIBUTORS.intValue());
        ((ObjectAssert)Assertions.assertThat(spaceRepo.getContributors().iterator().next()).hasFieldOrPropertyWithValue("username", (Object)CONTRIBUTOR)).hasFieldOrPropertyWithValue("type", (Object)ContributorType.OWNER);
        Assertions.assertThat((List)info.getSecurityGroups()).isEmpty();
    }
}

