/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import jsinterop.base.Js;
import org.kie.workbench.common.dmn.api.definition.HasComponentWidths;
import org.kie.workbench.common.dmn.api.definition.model.Context;
import org.kie.workbench.common.dmn.api.definition.model.DecisionTable;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.FunctionDefinition;
import org.kie.workbench.common.dmn.api.definition.model.Invocation;
import org.kie.workbench.common.dmn.api.definition.model.IsLiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.List;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.Relation;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.ContextPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.DecisionTablePropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.FunctionDefinitionPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.InvocationPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.ListPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.LiteralExpressionPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.RelationPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.utils.WrapperUtils;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITContext;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDecisionTable;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITExpression;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITFunctionDefinition;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITInvocation;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITList;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITLiteralExpression;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITRelation;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.kie.JSITComponentWidths;

public class ExpressionPropertyConverter {
    public static Expression wbFromDMN(JSITExpression dmn, JSITExpression parent, BiConsumer<String, HasComponentWidths> hasComponentWidthsConsumer) {
        if (JSITLiteralExpression.instanceOf((Object)dmn)) {
            JSITLiteralExpression jsiExpression = (JSITLiteralExpression)Js.uncheckedCast((Object)dmn);
            LiteralExpression e = LiteralExpressionPropertyConverter.wbFromDMN(jsiExpression);
            hasComponentWidthsConsumer.accept(dmn.getId(), (HasComponentWidths)e);
            return e;
        }
        if (JSITContext.instanceOf((Object)dmn)) {
            JSITContext jsiExpression = (JSITContext)Js.uncheckedCast((Object)dmn);
            Context e = ContextPropertyConverter.wbFromDMN(jsiExpression, parent, hasComponentWidthsConsumer);
            hasComponentWidthsConsumer.accept(dmn.getId(), (HasComponentWidths)e);
            return e;
        }
        if (JSITRelation.instanceOf((Object)dmn)) {
            JSITRelation jsiExpression = (JSITRelation)Js.uncheckedCast((Object)dmn);
            Relation e = RelationPropertyConverter.wbFromDMN(jsiExpression, hasComponentWidthsConsumer);
            hasComponentWidthsConsumer.accept(dmn.getId(), (HasComponentWidths)e);
            return e;
        }
        if (JSITList.instanceOf((Object)dmn)) {
            JSITList jsiExpression = (JSITList)Js.uncheckedCast((Object)dmn);
            List e = ListPropertyConverter.wbFromDMN(jsiExpression, hasComponentWidthsConsumer);
            hasComponentWidthsConsumer.accept(dmn.getId(), (HasComponentWidths)e);
            return e;
        }
        if (JSITInvocation.instanceOf((Object)dmn)) {
            JSITInvocation jsiExpression = (JSITInvocation)Js.uncheckedCast((Object)dmn);
            Invocation e = InvocationPropertyConverter.wbFromDMN(jsiExpression, hasComponentWidthsConsumer);
            hasComponentWidthsConsumer.accept(dmn.getId(), (HasComponentWidths)e);
            return e;
        }
        if (JSITFunctionDefinition.instanceOf((Object)dmn)) {
            JSITFunctionDefinition jsiExpression = (JSITFunctionDefinition)Js.uncheckedCast((Object)dmn);
            FunctionDefinition e = FunctionDefinitionPropertyConverter.wbFromDMN(jsiExpression, hasComponentWidthsConsumer);
            hasComponentWidthsConsumer.accept(dmn.getId(), (HasComponentWidths)e);
            return e;
        }
        if (JSITDecisionTable.instanceOf((Object)dmn)) {
            JSITDecisionTable jsiExpression = (JSITDecisionTable)Js.uncheckedCast((Object)dmn);
            DecisionTable e = DecisionTablePropertyConverter.wbFromDMN(jsiExpression);
            hasComponentWidthsConsumer.accept(dmn.getId(), (HasComponentWidths)e);
            return e;
        }
        return null;
    }

    public static JSITExpression dmnFromWB(Expression wb, Consumer<JSITComponentWidths> componentWidthsConsumer) {
        if (Objects.isNull(wb)) {
            return null;
        }
        String uuid = wb.getId().getValue();
        if (Objects.nonNull(uuid)) {
            JSITComponentWidths componentWidths = new JSITComponentWidths();
            componentWidths.setDmnElementRef(uuid);
            wb.getComponentWidths().stream().filter(Objects::nonNull).forEach(w -> componentWidths.addWidth(new Float((double)w).floatValue()));
            componentWidthsConsumer.accept(componentWidths);
        }
        if (wb instanceof IsLiteralExpression) {
            JSITLiteralExpression unwrappedJSITLiteralExpression = LiteralExpressionPropertyConverter.dmnFromWB((IsLiteralExpression)wb);
            JSITLiteralExpression wrappedJSITLiteralExpression = WrapperUtils.getWrappedJSITLiteralExpression(unwrappedJSITLiteralExpression, "dmn", "literalExpression");
            return wrappedJSITLiteralExpression;
        }
        if (wb instanceof Context) {
            JSITContext unwrappedJSITContext = ContextPropertyConverter.dmnFromWB((Context)wb, componentWidthsConsumer);
            JSITContext wrappedJSITContext = WrapperUtils.getWrappedJSITContext(unwrappedJSITContext, "dmn", "context");
            return wrappedJSITContext;
        }
        if (wb instanceof Relation) {
            JSITRelation unwrappedJSITRelation = RelationPropertyConverter.dmnFromWB((Relation)wb, componentWidthsConsumer);
            JSITRelation wrappedJSITRelation = WrapperUtils.getWrappedJSITRelation(unwrappedJSITRelation, "dmn", "relation");
            return wrappedJSITRelation;
        }
        if (wb instanceof List) {
            JSITList unwrappedJSITList = ListPropertyConverter.dmnFromWB((List)wb, componentWidthsConsumer);
            JSITList wrappedJSITList = WrapperUtils.getWrappedJSITList(unwrappedJSITList, "dmn", "list");
            return wrappedJSITList;
        }
        if (wb instanceof Invocation) {
            JSITInvocation unwrappedJSITInvocation = InvocationPropertyConverter.dmnFromWB((Invocation)wb, componentWidthsConsumer);
            JSITInvocation wrappedJSITInvocation = WrapperUtils.getWrappedJSITInvocation(unwrappedJSITInvocation, "dmn", "invocation");
            return wrappedJSITInvocation;
        }
        if (wb instanceof FunctionDefinition) {
            JSITFunctionDefinition unwrappedJSITFunctionDefinition = FunctionDefinitionPropertyConverter.dmnFromWB((FunctionDefinition)wb, componentWidthsConsumer);
            JSITFunctionDefinition wrappedJSITFunctionDefinition = WrapperUtils.getWrappedJSITFunctionDefinition(unwrappedJSITFunctionDefinition, "dmn", "functionDefinition");
            return wrappedJSITFunctionDefinition;
        }
        if (wb instanceof DecisionTable) {
            JSITDecisionTable unwrappedJSITDecisionTable = DecisionTablePropertyConverter.dmnFromWB((DecisionTable)wb);
            JSITDecisionTable wrappedJSITDecisionTable = WrapperUtils.getWrappedJSITDecisionTable(unwrappedJSITDecisionTable, "dmn", "decisionTable");
            return wrappedJSITDecisionTable;
        }
        return null;
    }
}

