/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model;

import java.util.Objects;
import java.util.Optional;
import org.kie.workbench.common.dmn.api.definition.model.ImportedValues;
import org.kie.workbench.common.dmn.api.property.dmn.ExpressionLanguage;
import org.kie.workbench.common.dmn.api.property.dmn.LocationURI;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.DescriptionPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.ExpressionLanguagePropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.IdPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITImportedValues;

public class ImportedValuesConverter {
    public static ImportedValues wbFromDMN(JSITImportedValues dmn) {
        if (Objects.isNull(dmn)) {
            return null;
        }
        String namespace = dmn.getNamespace();
        LocationURI locationURI = new LocationURI(dmn.getLocationURI());
        String importType = dmn.getImportType();
        String importedElement = dmn.getImportedElement();
        ExpressionLanguage expressionLanguage = ExpressionLanguagePropertyConverter.wbFromDMN(dmn.getExpressionLanguage());
        ImportedValues wb = new ImportedValues(namespace, locationURI, importType, importedElement, expressionLanguage);
        String name = dmn.getName();
        String description = dmn.getDescription();
        wb.setId(IdPropertyConverter.wbFromDMN(dmn.getId()));
        wb.setName(new Name(Objects.nonNull(name) ? name : wb.getId().getValue()));
        wb.setDescription(DescriptionPropertyConverter.wbFromDMN(description));
        return wb;
    }

    public static JSITImportedValues dmnFromWB(ImportedValues wb) {
        if (Objects.isNull(wb)) {
            return null;
        }
        JSITImportedValues dmn = new JSITImportedValues();
        dmn.setNamespace(wb.getNamespace());
        dmn.setLocationURI(wb.getLocationURI().getValue());
        dmn.setImportType(wb.getImportType());
        dmn.setImportedElement(wb.getImportedElement());
        dmn.setId(wb.getId().getValue());
        dmn.setName(wb.getName().getValue());
        Optional<String> description = Optional.ofNullable(DescriptionPropertyConverter.dmnFromWB(wb.getDescription()));
        description.ifPresent(arg_0 -> ((JSITImportedValues)dmn).setDescription(arg_0));
        dmn.setExpressionLanguage(ExpressionLanguagePropertyConverter.dmnFromWB(wb.getExpressionLanguage()));
        return dmn;
    }
}

