/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model;

import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.OutputClauseLiteralExpression;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.OutputClauseLiteralExpressionPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITLiteralExpression;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class OutputClauseLiteralExpressionPropertyConverterTest {
    private static final String TEXT = "text";
    @GwtMock
    private JSITLiteralExpression jsitLiteralExpression;

    @Test
    public void testWBFromDMNWhenNull() {
        OutputClauseLiteralExpression wb = OutputClauseLiteralExpressionPropertyConverter.wbFromDMN(null);
        Assertions.assertThat((Object)wb).isNotNull();
    }

    @Test
    public void testWBFromDMNWhenNonNull() {
        Mockito.when((Object)this.jsitLiteralExpression.getText()).thenReturn((Object)TEXT);
        OutputClauseLiteralExpression wb = OutputClauseLiteralExpressionPropertyConverter.wbFromDMN((JSITLiteralExpression)this.jsitLiteralExpression);
        Assertions.assertThat((Object)wb).isNotNull();
        Assertions.assertThat((String)wb.getText().getValue()).isEqualTo(TEXT);
    }

    @Test
    public void testDMNFromWBWhenNull() {
        JSITLiteralExpression dmn = OutputClauseLiteralExpressionPropertyConverter.dmnFromWB(null);
        Assertions.assertThat((Object)dmn).isNull();
    }

    @Test
    public void testDMNFromWBWhenTextIsNull() {
        OutputClauseLiteralExpression wb = new OutputClauseLiteralExpression();
        wb.setText(null);
        JSITLiteralExpression dmn = OutputClauseLiteralExpressionPropertyConverter.dmnFromWB((OutputClauseLiteralExpression)wb);
        Assertions.assertThat((Object)dmn).isNull();
    }

    @Test
    public void testDMNFromWBWhenNonNullWithEmptyString() {
        OutputClauseLiteralExpression wb = new OutputClauseLiteralExpression();
        wb.getText().setValue("");
        JSITLiteralExpression dmn = OutputClauseLiteralExpressionPropertyConverter.dmnFromWB((OutputClauseLiteralExpression)wb);
        Assertions.assertThat((Object)dmn).isNull();
    }

    @Test
    public void testDMNFromWBWhenNonNullWithNonEmptyString() {
        OutputClauseLiteralExpression wb = new OutputClauseLiteralExpression();
        wb.getText().setValue(TEXT);
        JSITLiteralExpression dmn = OutputClauseLiteralExpressionPropertyConverter.dmnFromWB((OutputClauseLiteralExpression)wb);
        Assertions.assertThat((Object)dmn).isNotNull();
        ((JSITLiteralExpression)Mockito.verify((Object)this.jsitLiteralExpression)).setText(TEXT);
    }
}

