/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import jsinterop.base.Js;
import org.kie.workbench.common.dmn.api.definition.HasComponentWidths;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.api.definition.model.Relation;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.DescriptionPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.IdPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.InformationItemPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.ListPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.QNamePropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITInformationItem;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITList;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITRelation;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.kie.JSITComponentWidths;

public class RelationPropertyConverter {
    public static Relation wbFromDMN(JSITRelation dmn, BiConsumer<String, HasComponentWidths> hasComponentWidthsConsumer) {
        Id id = IdPropertyConverter.wbFromDMN(dmn.getId());
        Description description = DescriptionPropertyConverter.wbFromDMN(dmn.getDescription());
        QName typeRef = QNamePropertyConverter.wbFromDMN(dmn.getTypeRef());
        ArrayList<InformationItem> convertedColumns = new ArrayList<InformationItem>();
        List jsiColumns = dmn.getColumn();
        for (int i = 0; i < jsiColumns.size(); ++i) {
            JSITInformationItem jsiColumn = (JSITInformationItem)Js.uncheckedCast(jsiColumns.get(i));
            convertedColumns.add(InformationItemPropertyConverter.wbFromDMN(jsiColumn));
        }
        ArrayList<org.kie.workbench.common.dmn.api.definition.model.List> convertedRows = new ArrayList<org.kie.workbench.common.dmn.api.definition.model.List>();
        List jsiRows = dmn.getRow();
        for (int i = 0; i < jsiRows.size(); ++i) {
            JSITList jsiRow = (JSITList)Js.uncheckedCast(jsiRows.get(i));
            convertedRows.add(ListPropertyConverter.wbFromDMN(jsiRow, hasComponentWidthsConsumer));
        }
        Relation result = new Relation(id, description, typeRef, convertedColumns, convertedRows);
        for (InformationItem column : convertedColumns) {
            if (!Objects.nonNull(column)) continue;
            column.setParent((DMNModelInstrumentedBase)result);
        }
        for (org.kie.workbench.common.dmn.api.definition.model.List row : convertedRows) {
            if (!Objects.nonNull(row)) continue;
            row.setParent((DMNModelInstrumentedBase)result);
        }
        return result;
    }

    public static JSITRelation dmnFromWB(Relation wb, Consumer<JSITComponentWidths> componentWidthsConsumer) {
        JSITRelation result = new JSITRelation();
        result.setId(wb.getId().getValue());
        Optional<String> description = Optional.ofNullable(DescriptionPropertyConverter.dmnFromWB(wb.getDescription()));
        description.ifPresent(arg_0 -> ((JSITRelation)result).setDescription(arg_0));
        QNamePropertyConverter.setDMNfromWB(wb.getTypeRef(), arg_0 -> ((JSITRelation)result).setTypeRef(arg_0));
        for (InformationItem iitem : wb.getColumn()) {
            JSITInformationItem iitemConverted = InformationItemPropertyConverter.dmnFromWB(iitem);
            result.addColumn(iitemConverted);
        }
        for (org.kie.workbench.common.dmn.api.definition.model.List list : wb.getRow()) {
            JSITList listConverted = ListPropertyConverter.dmnFromWB(list, componentWidthsConsumer);
            result.addRow(listConverted);
        }
        return result;
    }
}

